/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.maven.project.Project;
import org.mevenide.context.JDomProjectUnmarshaller;
import org.mevenide.project.io.CarefulProjectMarshaller;
import org.mevenide.util.MevenideUtils;
import org.mevenide.util.StringUtils;

public final class PomSkeletonBuilder {
    private static final String DEFAULT_TEMPLATE = "/templates/standard/project.xml";
    private File template;

    private PomSkeletonBuilder() {
    }

    public static PomSkeletonBuilder getSkeletonBuilder(String template) throws Exception {
        PomSkeletonBuilder pomBuilder = new PomSkeletonBuilder();
        if (template != null && new File(template).exists()) {
            pomBuilder.template = new File(template);
        }
        return pomBuilder;
    }

    public static PomSkeletonBuilder getSkeletonBuilder() throws Exception {
        return PomSkeletonBuilder.getSkeletonBuilder(null);
    }

    public String getPomSkeleton(String projectName) throws Exception {
        return this.getPomSkeleton(projectName, projectName, projectName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPomSkeleton(String projectName, String groupId, String artifactId, String version, String shortDescription) throws Exception {
        if (StringUtils.isNull(projectName)) {
            throw new Exception("Project name should be defined");
        }
        InputStream is = null;
        try {
            is = this.template != null ? new FileInputStream(this.template) : PomSkeletonBuilder.class.getResourceAsStream(DEFAULT_TEMPLATE);
            File file = MevenideUtils.createFile(is);
            Project project = new JDomProjectUnmarshaller().parse(file);
            if (StringUtils.isNull(artifactId)) {
                artifactId = projectName;
            }
            if (StringUtils.isNull(groupId)) {
                groupId = projectName;
            }
            project.setId(artifactId.toLowerCase());
            project.setName(projectName);
            project.setGroupId(groupId.toLowerCase());
            project.setArtifactId(artifactId.toLowerCase());
            project.setInceptionYear(PomSkeletonBuilder.getCurrentYear());
            if (!StringUtils.isNull(version)) {
                project.setCurrentVersion(version);
            }
            if (!StringUtils.isNull(shortDescription)) {
                project.setShortDescription(shortDescription);
            }
            StringWriter writer = new StringWriter();
            new CarefulProjectMarshaller().marshall((Writer)writer, project);
            ((Writer)writer).close();
            String string = ((Object)writer).toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static String getCurrentYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        return Integer.toString(calendar.get(1));
    }
}

