/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Build;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.context.JDomProjectUnmarshaller;
import org.mevenide.project.io.JarOverrideReader2;
import org.mevenide.util.StringUtils;

public class ProjectReader {
    private static final Log log = LogFactory.getLog((Class)ProjectReader.class);
    private JDomProjectUnmarshaller unmarshaller = new JDomProjectUnmarshaller();
    private static ProjectReader projectReader = null;

    public static synchronized ProjectReader getReader() throws Exception {
        if (projectReader == null) {
            projectReader = new ProjectReader();
        }
        return projectReader;
    }

    private ProjectReader() throws Exception {
    }

    public Project read(File pom) throws Exception {
        Project project = this.unmarshaller.parse(pom);
        project.setFile(pom);
        DefaultQueryContext context = new DefaultQueryContext(pom.getParentFile());
        JarOverrideReader2.getInstance().processOverride(project, (IQueryContext)context);
        return project;
    }

    public Map readSourceDirectories(File pom) throws Exception {
        String unitTestSourceDirectory;
        String sourceDirectory;
        HashMap<String, String> sourceDirectories = new HashMap<String, String>();
        Build build = this.getBuild(pom);
        String aspectSourceDirectory = build.getAspectSourceDirectory();
        if (!StringUtils.isNull(aspectSourceDirectory)) {
            sourceDirectories.put("aspectSourceDirectory", aspectSourceDirectory);
        }
        if (!StringUtils.isNull(sourceDirectory = build.getSourceDirectory())) {
            sourceDirectories.put("sourceDirectory", sourceDirectory);
        }
        if (!StringUtils.isNull(unitTestSourceDirectory = build.getUnitTestSourceDirectory())) {
            sourceDirectories.put("unitTestSourceDirectory", unitTestSourceDirectory);
        }
        return sourceDirectories;
    }

    public Dependency extractDependency(File referencedPom) throws Exception {
        Project referencedProject = this.read(referencedPom);
        Dependency dependency = new Dependency();
        dependency.setGroupId(referencedProject.getGroupId());
        dependency.setArtifactId(referencedProject.getArtifactId());
        dependency.setVersion(referencedProject.getCurrentVersion());
        return dependency;
    }

    public Map readAllResources(File pom) throws Exception {
        Hashtable allResources = new Hashtable();
        Project project = this.read(pom);
        if (project.getBuild() != null) {
            List resources = project.getBuild().getResources();
            allResources.putAll(this.readResources(project, resources, "resources"));
            if (project.getBuild().getUnitTest() != null) {
                List unitTestResources = project.getBuild().getUnitTest().getResources();
                allResources.putAll(this.readResources(project, unitTestResources, "unitTestResources"));
            }
        }
        return allResources;
    }

    Map readResources(Project project, List resources, String resourceType) {
        TreeMap<String, String> resourceMap = new TreeMap<String, String>();
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                String directory = ((Resource)resources.get(i)).getDirectory();
                if (resourceMap.containsValue(directory)) continue;
                resourceMap.put(directory, resourceType);
            }
        }
        return resourceMap;
    }

    private Build getBuild(File pom) throws Exception {
        Project project = pom != null ? new JDomProjectUnmarshaller().parse(pom) : new Project();
        Build build = project.getBuild();
        if (build == null) {
            build = new Build();
        }
        return build;
    }
}

