/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenUtils;
import org.apache.maven.project.Build;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.apache.maven.project.UnitTest;
import org.apache.maven.repository.Artifact;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.project.dependency.DependencyUtil;
import org.mevenide.project.io.CarefulProjectMarshaller;
import org.mevenide.project.io.IProjectMarshaller;
import org.mevenide.project.io.JarOverrideWriter;
import org.mevenide.project.io.ProjectReader;
import org.mevenide.project.resource.ResourceUtil;
import org.mevenide.project.source.SourceDirectoryUtil;

public class ProjectWriter {
    private static Log log = LogFactory.getLog((Class)ProjectWriter.class);
    private static ProjectWriter projectWriter = null;
    private ProjectReader projectReader;
    private IProjectMarshaller marshaller;
    private JarOverrideWriter jarOverrideWriter = new JarOverrideWriter(this);
    private ILocationFinder locationFinder;

    private ProjectWriter() throws Exception {
        this.marshaller = new CarefulProjectMarshaller();
        this.projectReader = ProjectReader.getReader();
        this.locationFinder = ConfigUtils.getDefaultLocationFinder();
    }

    public static synchronized ProjectWriter getWriter() throws Exception {
        if (projectWriter == null) {
            projectWriter = new ProjectWriter();
        }
        return projectWriter;
    }

    public void addResource(String path, File pom, String[] exclusionPatterns) throws Exception {
        Project project = this.projectReader.read(pom);
        if (project.getBuild() == null) {
            project.setBuild(new Build());
        }
        Resource resource = ResourceUtil.newResource(path, exclusionPatterns);
        if (project.getBuild().getResources() == null) {
            project.getBuild().setResources(new ArrayList());
        }
        project.getBuild().getResources().add(resource);
        this.write(project, pom);
    }

    public void addUnitTestResource(String path, File pom, String[] exclusionPatterns) throws Exception {
        Project project = this.projectReader.read(pom);
        if (project.getBuild() == null) {
            project.setBuild(new Build());
        }
        if (project.getBuild().getUnitTest() == null) {
            project.getBuild().setUnitTest(new UnitTest());
        }
        Resource resource = ResourceUtil.newResource(path, exclusionPatterns);
        if (project.getBuild().getUnitTest().getResources() == null) {
            project.getBuild().getUnitTest().setResources(new ArrayList());
        }
        project.getBuild().getUnitTest().getResources().add(resource);
        this.write(project, pom);
    }

    public void addSource(String path, File pom, String sourceType) throws Exception {
        Project project = this.projectReader.read(pom);
        if (!SourceDirectoryUtil.isSourceDirectoryPresent(project, path)) {
            SourceDirectoryUtil.addSource(project, path, sourceType);
            this.write(project, pom);
        }
    }

    public void setArtifacts(List artifacts, Project project) throws Exception {
        this.setArtifacts(artifacts, project, true);
    }

    public void setArtifacts(List artifacts, Project project, boolean shouldWriteProperties) throws Exception {
        List dependencies = project.getDependencies();
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)artifacts.get(i);
            Dependency dependency = artifact.getDependency();
            if (this.contains(dependencies, dependency)) continue;
            dependencies.add(dependency);
            String path = artifact.getPath();
            path = MavenUtils.makeRelativePath((File)project.getFile().getParentFile(), (String)path);
            if (!shouldWriteProperties || artifact.getPath().startsWith(this.locationFinder.getMavenLocalRepository())) continue;
            this.jarOverrideWriter.jarOverride(dependency.getArtifactId(), path, project);
        }
        project.setDependencies(dependencies);
        this.write(project);
    }

    private boolean contains(List dependencies, Dependency dependency) {
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency d = (Dependency)dependencies.get(i);
            if (!DependencyUtil.areEquals(d, dependency)) continue;
            return true;
        }
        return false;
    }

    void write(Project project, File pom) throws Exception {
        FileWriter writer = new FileWriter(pom, false);
        this.marshaller.marshall(writer, project);
        ((Writer)writer).close();
    }

    public void addProject(File referencedPom, File pom) throws Exception {
        ProjectReader reader = ProjectReader.getReader();
        Dependency dependency = reader.extractDependency(referencedPom);
        Project project = reader.read(pom);
        project.addDependency(dependency);
        this.write(project, pom);
    }

    public void updateExtend(File pomFile, boolean isInherited, String parentPom) throws Exception {
        log.debug((Object)("isInherited = " + isInherited + " ; parentPom = " + parentPom));
        ProjectReader reader = ProjectReader.getReader();
        Project project = reader.read(pomFile);
        if (!isInherited) {
            project.setExtend(null);
        } else {
            project.setExtend(parentPom);
        }
        this.marshaller.marshall(new FileWriter(pomFile), project);
    }

    public void write(Project project) throws Exception {
        if (project.getFile() != null) {
            FileWriter writer = new FileWriter(project.getFile());
            this.marshaller.marshall(writer, project);
        }
    }

    public void removeDirectory(Project project, String path, String type) throws Exception {
        if ("sourceDirectory".equals(type) || "unitTestSourceDirectory".equals(type) || "aspectSourceDirectory".equals(type)) {
            this.removeSource(project, path);
        } else if ("resources".equals(type) || "unitTestResources".equals(type)) {
            this.removeResource(project, path);
        } else {
            throw new Exception("unhandled type : " + type);
        }
        this.write(project);
    }

    public void removeResource(Project project, String path) throws Exception {
        if (project != null && project.getBuild() != null) {
            List resources = project.getBuild().getResources();
            if (resources != null && resources.size() > 0) {
                this.removeResource(resources, path);
                project.getBuild().setResources(resources);
            }
            if (project.getBuild().getUnitTest() != null) {
                List unitTestResources = project.getBuild().getUnitTest().getResources();
                if (resources != null) {
                    this.removeResource(unitTestResources, path);
                    project.getBuild().getUnitTest().setResources(unitTestResources);
                }
            }
        }
    }

    private void removeResource(List resources, String path) {
        if (resources != null) {
            Iterator sourceIterator = resources.iterator();
            boolean changed = false;
            while (sourceIterator.hasNext()) {
                String iteratedResource = ((Resource)sourceIterator.next()).getDirectory();
                if (!path.equals(iteratedResource)) continue;
                sourceIterator.remove();
                changed = true;
            }
        }
    }

    public void removeSource(Project project, String path) throws Exception {
        if (project != null && project.getBuild() != null && path != null) {
            if (path.equals(project.getBuild().getSourceDirectory())) {
                project.getBuild().setSourceDirectory(null);
            }
            if (path.equals(project.getBuild().getAspectSourceDirectory())) {
                project.getBuild().setAspectSourceDirectory(null);
            }
            if (path.equals(project.getBuild().getUnitTestSourceDirectory())) {
                project.getBuild().setUnitTestSourceDirectory(null);
            }
        }
    }

    public void removeArtifact(Project project, Artifact artifact) throws Exception {
        if (project == null) {
            throw new Exception("project shouldnot be null");
        }
        if (artifact == null) {
            throw new Exception("artifact shouldnot be null");
        }
        List projectDependencies = project.getDependencies();
        ArrayList iteratedList = new ArrayList(projectDependencies);
        int idx = 0;
        boolean warn = true;
        for (int i = 0; i < iteratedList.size(); ++i) {
            Dependency iteratedDependency = (Dependency)iteratedList.get(i);
            if (DependencyUtil.areEquals(project, artifact.getDependency(), iteratedDependency)) {
                project.getDependencies().remove(idx);
                warn = false;
                continue;
            }
            ++idx;
        }
        if (warn) {
            log.warn((Object)"specified dependency not found");
        } else {
            ProjectWriter.getWriter().write(project);
        }
    }
}

