/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.project.io.IContentProvider;

public class ProxyContentProvider
implements IContentProvider {
    private static final Log log = LogFactory.getLog((Class)ProxyContentProvider.class);
    protected IContentProvider provider;

    public ProxyContentProvider(IContentProvider origin) {
        this.provider = origin;
    }

    protected IContentProvider createChildContentProvider(IContentProvider origin) {
        return new ProxyContentProvider(origin);
    }

    public IContentProvider getSubContentProvider(String key) {
        IContentProvider child = this.provider.getSubContentProvider(key);
        return child != null ? this.createChildContentProvider(child) : null;
    }

    public String getValue(String key) {
        return this.provider.getValue(key);
    }

    public List getSubContentProviderList(String parentKey, String childKey) {
        List orig = this.provider.getSubContentProviderList(parentKey, childKey);
        if (orig != null) {
            Iterator it = orig.iterator();
            ArrayList<IContentProvider> toReturn = new ArrayList<IContentProvider>();
            while (it.hasNext()) {
                IContentProvider obj = (IContentProvider)it.next();
                toReturn.add(this.createChildContentProvider(obj));
            }
            return toReturn;
        }
        return null;
    }

    public List getValueList(String parentKey, String childKey) {
        return this.provider.getValueList(parentKey, childKey);
    }

    public List getProperties() {
        return this.provider.getProperties();
    }
}

