/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.resource;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.mevenide.project.resource.IResourceResolver;

public class DefaultResourceResolver
implements IResourceResolver {
    public void mergeSimilarResources(Project project, Resource resource) {
        List resources = project.getBuild().getResources();
        this.prepareResource(resource, resources);
        project.getBuild().addResource(resource);
    }

    public void mergeSimilarUnitTestResources(Project project, Resource resource) {
        List resources = project.getBuild().getUnitTest().getResources();
        this.prepareResource(resource, resources);
        project.getBuild().getUnitTest().addResource(resource);
    }

    private void prepareResource(Resource resource, List resources) {
        List similar = this.getSimilarResources(resources, resource);
        for (int i = 0; i < similar.size(); ++i) {
            Resource similarResource = (Resource)similar.get(i);
            this.mergeIncludes(resource, similarResource);
            this.mergeExcludes(resource, similarResource);
            resources.remove(similarResource);
        }
    }

    private void mergeExcludes(Resource resource, Resource similarResource) {
        for (int j = 0; j < similarResource.getExcludes().size(); ++j) {
            if (resource.getExcludes().contains(similarResource.getExcludes().get(j))) continue;
            resource.getExcludes().add(similarResource.getExcludes().get(j));
        }
    }

    private void mergeIncludes(Resource resource, Resource similarResource) {
        for (int j = 0; j < similarResource.getIncludes().size(); ++j) {
            if (resource.getIncludes().contains(similarResource.getIncludes().get(j))) continue;
            resource.getIncludes().add(similarResource.getIncludes().get(j));
        }
    }

    private List getSimilarResources(List resources, Resource resource) {
        ArrayList<Resource> similar = new ArrayList<Resource>();
        for (int i = 0; i < resources.size(); ++i) {
            Resource declaredResource = (Resource)resources.get(i);
            if (!declaredResource.getDirectory().equals(resource.getDirectory())) continue;
            similar.add(declaredResource);
        }
        return similar;
    }
}

