/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.mevenide.util.StringUtils;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static Resource newResource(String path, String[] exclusionPatterns) {
        Resource resource = new Resource();
        resource.setDirectory(path);
        for (int i = 0; i < exclusionPatterns.length; ++i) {
            resource.addExclude(exclusionPatterns[i]);
        }
        return resource;
    }

    public static boolean isResourcePresent(Project project, String directory) {
        if (directory == null) {
            return false;
        }
        if (project.getBuild() == null) {
            return false;
        }
        List buildResources = project.getBuild().getResources();
        Iterator itr = buildResources.iterator();
        while (itr.hasNext()) {
            Resource resource = (Resource)itr.next();
            if (resource.getDirectory() == null || !resource.getDirectory().equals(directory)) continue;
            return true;
        }
        if (project.getBuild().getUnitTest() == null) {
            return false;
        }
        List unitTestResources = project.getBuild().getUnitTest().getResources();
        Iterator itr2 = unitTestResources.iterator();
        while (itr2.hasNext()) {
            Resource resource = (Resource)itr2.next();
            if (resource.getDirectory() == null || !resource.getDirectory().equals(directory)) continue;
            return true;
        }
        return false;
    }

    public static boolean areEquivalent(Resource res1, Resource res2) {
        if (res1 == null && res2 == null) {
            return true;
        }
        if (res1 != null) {
            if (res2 == null) {
                return false;
            }
            return StringUtils.relaxEqual(res1.getDirectory(), res2.getDirectory());
        }
        return false;
    }

    public static void remove(List resources, Resource resource) {
        ArrayList resCopy = new ArrayList();
        resCopy.addAll(resources);
        for (int u = 0; u < resCopy.size(); ++u) {
            for (int i = 0; i < resources.size(); ++i) {
                if (!ResourceUtil.areEquivalent((Resource)resCopy.get(u), (Resource)resources.get(i))) continue;
                resources.remove(i);
            }
        }
    }
}

