/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.source;

import org.apache.maven.project.Build;
import org.apache.maven.project.Project;
import org.apache.maven.project.UnitTest;

public final class SourceDirectoryUtil {
    private SourceDirectoryUtil() {
    }

    public static void addSource(Project project, String path, String sourceType) {
        if (project.getBuild() == null) {
            project.setBuild(new Build());
        }
        if ("aspectSourceDirectory".equals(sourceType)) {
            project.getBuild().setAspectSourceDirectory(path);
        }
        if ("sourceDirectory".equals(sourceType)) {
            project.getBuild().setSourceDirectory(path);
        }
        if ("unitTestSourceDirectory".equals(sourceType)) {
            project.getBuild().setUnitTestSourceDirectory(path);
            UnitTest unitTest = project.getBuild().getUnitTest();
        }
    }

    public static boolean isSourceDirectoryPresent(Project project, String path) {
        if (project.getBuild() == null || path == null) {
            return false;
        }
        String srcDirectory = project.getBuild().getSourceDirectory();
        String aspectSrcDirectory = project.getBuild().getAspectSourceDirectory();
        String unitTestSourceDirectory = project.getBuild().getUnitTestSourceDirectory();
        return path.equals(srcDirectory) || path.equals(aspectSrcDirectory) || path.equals(unitTestSourceDirectory);
    }

    public static String stripBasedir(String strg) {
        if ("${basedir}".equals(strg) || "${basedir}/".equals(strg) || "${basedir}\\".equals(strg)) {
            return strg;
        }
        String result = SourceDirectoryUtil.stripHeadingString(strg, "${basedir}/");
        result = SourceDirectoryUtil.stripHeadingString(result, "${basedir}\\");
        result = SourceDirectoryUtil.stripHeadingString(result, "${basedir}");
        return result;
    }

    private static String stripHeadingString(String strg, String headingString) {
        if (strg.startsWith(headingString)) {
            strg = strg.substring(headingString.length());
        }
        return strg;
    }
}

