/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.validation;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.Project;
import org.apache.maven.util.StringInputStream;
import org.mevenide.project.io.CarefulProjectMarshaller;
import org.mevenide.project.validation.IProjectValidator;
import org.mevenide.project.validation.ValidationException;
import org.mevenide.project.validation.ValidationProblem;
import org.mevenide.util.ProjectUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator
implements IProjectValidator {
    private List errors;
    private List warnings;

    public SchemaValidator() {
        this.initialize();
    }

    public void validate(File file) throws ValidationException {
        ErrorHandler err = new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                ValidationProblem problem = new ValidationProblem(exception);
                if (!SchemaValidator.this.errors.contains(problem)) {
                    SchemaValidator.this.errors.add(problem);
                }
            }

            public void fatalError(SAXParseException exception) throws SAXParseException {
                ValidationProblem problem = new ValidationProblem(exception);
                if (!SchemaValidator.this.errors.contains(problem)) {
                    SchemaValidator.this.errors.add(problem);
                }
            }

            public void warning(SAXParseException exception) throws SAXParseException {
                ValidationProblem problem = new ValidationProblem(exception);
                if (!SchemaValidator.this.warnings.contains(problem)) {
                    SchemaValidator.this.warnings.add(problem);
                }
            }
        };
        SinglePropertyMap map = new SinglePropertyMap((PropertyId)ValidateProperty.ERROR_HANDLER, (Object)err);
        ValidationDriver driver = new ValidationDriver((PropertyMap)map);
        try {
            InputStream schema = this.getClass().getResourceAsStream("/maven-project.xsd");
            driver.loadSchema(new InputSource(schema));
            Project pom = ProjectUtils.resolveProjectTree(file);
            StringWriter stringWriter = new StringWriter();
            new CarefulProjectMarshaller().marshall((Writer)stringWriter, pom);
            System.out.println(stringWriter);
            driver.validate(new InputSource((InputStream)new StringInputStream(((Object)stringWriter).toString())));
        }
        catch (Exception e) {
            this.warnings.add("Unable to validate pom against schema due to : " + e);
            throw new ValidationException(this.errors, this.warnings);
        }
        if (!this.errors.isEmpty() || !this.warnings.isEmpty()) {
            throw new ValidationException(this.errors, this.warnings);
        }
    }

    private void initialize() {
        this.errors = new ArrayList();
        this.warnings = new ArrayList();
    }
}

