/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.runner;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.CustomLocationFinder;

public abstract class AbstractRunner
extends CustomLocationFinder {
    private static final Log log = LogFactory.getLog((Class)AbstractRunner.class);
    private String[] finalOptions = null;

    public synchronized String[] getFinalOptions() {
        if (this.finalOptions == null) {
            String basedir = this.getBasedir();
            this.finalOptions = new String[3];
            this.finalOptions[0] = " ";
            this.finalOptions[1] = "-f";
            String tmpFile = basedir != null ? basedir + File.separator + "project.xml" : "project.xml";
            this.finalOptions[2] = new File(tmpFile).getAbsolutePath();
        }
        return this.finalOptions;
    }

    public void run(String[] options, String[] goals) {
        try {
            this.initEnvironment();
            this.launchVM(options, goals);
        }
        catch (Exception e) {
            log.debug((Object)("Cannot run Maven due to : " + e), (Throwable)e);
        }
    }

    protected String[] getMavenArgs(String[] options, String[] goals) {
        String[] mavenArgs = new String[options.length + goals.length + this.getFinalOptions().length];
        System.arraycopy(this.getFinalOptions(), 0, mavenArgs, 0, this.getFinalOptions().length);
        System.arraycopy(options, 0, mavenArgs, this.getFinalOptions().length, options.length);
        System.arraycopy(goals, 0, mavenArgs, this.getFinalOptions().length + options.length, goals.length);
        return mavenArgs;
    }

    protected abstract void initEnvironment() throws Exception;

    protected abstract String getBasedir();

    public abstract String getToolsJar();

    protected abstract void launchVM(String[] var1, String[] var2) throws Exception;
}

