/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.runner;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.runner.AbstractRunner;
import org.mevenide.runner.RunnerHelper;
import org.mevenide.util.StringUtils;

public final class ArgumentsManager {
    private ArgumentsManager() {
    }

    public static String[] getMavenClasspath() {
        return new String[]{RunnerHelper.getHelper().getForeheadLibrary()};
    }

    public static String[] getVMArgs(AbstractRunner runner) {
        String[] properties = ArgumentsManager.getRawProperties(runner);
        String[] vmArgs = new String[properties.length + 1];
        vmArgs[0] = "-Xmx" + ConfigUtils.getHeapSize() + "M";
        for (int i = 1; i < properties.length + 1; ++i) {
            vmArgs[i] = properties[i - 1];
        }
        return vmArgs;
    }

    static String[] getRawProperties(AbstractRunner runner) {
        Map sysProps = ArgumentsManager.getSystemProperties(runner);
        Set keys = sysProps.keySet();
        String[] rawProps = new String[keys.size()];
        Iterator iterator = keys.iterator();
        int u = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            rawProps[u] = "-D" + key + "=" + (String)sysProps.get(key);
            ++u;
        }
        return rawProps;
    }

    public static Map getSystemProperties(AbstractRunner runner) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        props.put("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        ILocationFinder config = ConfigUtils.getDefaultLocationFinder();
        props.put("maven.home", StringUtils.isNull(runner.getMavenHome()) ? config.getMavenHome() : runner.getMavenHome());
        props.put("maven.home.local", StringUtils.isNull(runner.getMavenLocalHome()) ? config.getMavenLocalHome() : runner.getMavenLocalHome());
        props.put("java.home", StringUtils.isNull(runner.getJavaHome()) ? config.getMavenLocalHome() : runner.getJavaHome());
        props.put("maven.repo.local", StringUtils.isNull(runner.getMavenLocalRepository()) ? config.getMavenLocalRepository() : runner.getMavenLocalRepository());
        props.put("forehead.conf.file", ConfigUtils.getConfigurationFile());
        props.put("java.endorsed.dirs", ConfigUtils.getEndorsedDirs());
        props.put("basedir", runner.getBasedir());
        return props;
    }
}

