/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.runner;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.runner.InvalidOptionException;

public final class OptionsRegistry {
    private static Log log = LogFactory.getLog((Class)OptionsRegistry.class);
    private static OptionsRegistry registry = new OptionsRegistry();
    private Map options = new TreeMap();

    public static OptionsRegistry getRegistry() {
        return registry;
    }

    private OptionsRegistry() {
        try {
            Properties props = new Properties();
            InputStream stream = OptionsRegistry.class.getResourceAsStream("/mevenide.properties");
            props.load(stream);
            Iterator<Object> keys = props.keySet().iterator();
            log.debug((Object)("Found " + props.keySet().size() + " total keys"));
            while (keys.hasNext()) {
                String key = (String)keys.next();
                log.debug((Object)("current key = " + key));
                Character optionChar = new Character(key.charAt(key.length() - 1));
                log.debug((Object)("Found optionChar " + optionChar));
                this.registerCharOption(optionChar.charValue(), (String)props.get(key));
            }
        }
        catch (Exception e) {
            log.debug((Object)("Unable to init options map due to : " + e));
        }
    }

    public void registerCharOption(char option, String optionDescription) {
        this.options.put(new Character(option), optionDescription);
    }

    public void registerCharOption(char option) {
        this.registerCharOption(option, "No available description");
    }

    public String getDescription(char option) throws InvalidOptionException {
        log.debug((Object)("Looking up through " + this.options.size() + " keys "));
        String description = (String)this.options.get(new Character(option));
        if (description == null) {
            throw new InvalidOptionException(option);
        }
        return description;
    }
}

