/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.runner;

import java.io.File;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.runner.AbstractRunner;
import org.mevenide.util.StringUtils;

public class RunnerUtils {
    private RunnerUtils() {
    }

    public static String getToolsJar() {
        ILocationFinder config = ConfigUtils.getDefaultLocationFinder();
        return RunnerUtils.getToolsJar(config.getJavaHome());
    }

    public static String getToolsJar(AbstractRunner runner) {
        if (StringUtils.isNull(runner.getToolsJar())) {
            return RunnerUtils.getToolsJar(runner.getJavaHome());
        }
        return runner.getToolsJar();
    }

    private static String getToolsJar(String javaHome) {
        String toolsJar = javaHome + File.separator + "lib" + File.separator + "tools.jar";
        if (!new File(toolsJar).exists()) {
            toolsJar = new File(javaHome).getParent();
            String classesJarPart = "Classes/classes.jar";
            toolsJar = toolsJar.endsWith("/") ? toolsJar + classesJarPart : toolsJar + "/" + classesJarPart;
        }
        return toolsJar;
    }
}

