/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Organization;
import org.apache.maven.project.Project;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.mevenide.context.IProjectUnmarshaller;
import org.mevenide.util.DeprecationWarning;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefaultProjectUnmarshaller
implements IProjectUnmarshaller {
    public Project parse(Reader reader) throws Exception {
        Project project = new Project();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1.MXParserFactory", Thread.currentThread().getContextClassLoader().getClass());
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                Developer d;
                Branch b;
                String id;
                if (parser.getName().equals("extend")) {
                    project.setExtend(parser.nextText());
                } else if (parser.getName().equals("pomVersion")) {
                    project.setPomVersion(parser.nextText());
                } else if (parser.getName().equals("groupId")) {
                    project.setGroupId(parser.nextText());
                } else if (parser.getName().equals("artifactId")) {
                    project.setArtifactId(parser.nextText());
                } else if (parser.getName().equals("id")) {
                    DeprecationWarning.warn("<project/> element: You should be using groupId / artifactId");
                    project.setId(parser.nextText());
                } else if (parser.getName().equals("name")) {
                    project.setName(parser.nextText());
                } else if (parser.getName().equals("logo")) {
                    project.setLogo(parser.nextText());
                } else if (parser.getName().equals("currentVersion")) {
                    project.setCurrentVersion(parser.nextText());
                } else if (parser.getName().equals("inceptionYear")) {
                    project.setInceptionYear(parser.nextText());
                } else if (parser.getName().equals("package")) {
                    project.setPackage(parser.nextText());
                } else if (parser.getName().equals("gumpRepositoryId")) {
                    project.setGumpRepositoryId(parser.nextText());
                } else if (parser.getName().equals("description")) {
                    project.setDescription(parser.nextText());
                } else if (parser.getName().equals("shortDescription")) {
                    project.setShortDescription(parser.nextText());
                } else if (parser.getName().equals("url")) {
                    project.setUrl(parser.nextText());
                } else if (parser.getName().equals("issueTrackingUrl")) {
                    project.setIssueTrackingUrl(parser.nextText());
                } else if (parser.getName().equals("siteAddress")) {
                    project.setSiteAddress(parser.nextText());
                } else if (parser.getName().equals("siteDirectory")) {
                    project.setSiteDirectory(parser.nextText());
                } else if (parser.getName().equals("distributionSite")) {
                    project.setDistributionSite(parser.nextText());
                } else if (parser.getName().equals("distributionDirectory")) {
                    project.setDistributionDirectory(parser.nextText());
                } else if (parser.getName().equals("organization")) {
                    project.setOrganization(new Organization());
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("name")) {
                            project.getOrganization().setName(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("url")) {
                            project.getOrganization().setUrl(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("logo")) {
                            project.getOrganization().setLogo(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("repository")) {
                    project.setRepository(new Repository());
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("connection")) {
                            project.getRepository().setConnection(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("developerConnection")) {
                            project.getRepository().setDeveloperConnection(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("url")) {
                            project.getRepository().setUrl(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("versions")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("version")) {
                            Version v = new Version();
                            project.addVersion(v);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("id")) {
                                    id = parser.nextText();
                                    v.setId(id);
                                    continue;
                                }
                                if (parser.getName().equals("name")) {
                                    v.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("tag")) {
                                    v.setTag(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("branches")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("branch")) {
                            b = new Branch();
                            project.addBranch(b);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("tag")) {
                                    b.setTag(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("licenses")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("license")) {
                            License l = new License();
                            project.addLicense(l);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("name")) {
                                    l.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("distribution")) {
                                    l.setDistribution(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("url")) {
                                    l.setUrl(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("comments")) {
                                    l.setComments(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("mailingLists")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mailingList")) {
                            MailingList ml = new MailingList();
                            project.addMailingList(ml);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("name")) {
                                    ml.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("subscribe")) {
                                    ml.setSubscribe(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("unsubscribe")) {
                                    ml.setUnsubscribe(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("archive")) {
                                    ml.setArchive(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("developers")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("developer")) {
                            d = new Developer();
                            project.addDeveloper(d);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("id")) {
                                    d.setId(parser.nextText());
                                    continue;
                                }
                                this.unmarshallContributorDetails(parser, (Contributor)d);
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("contributors")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("contributor")) {
                            Contributor c = new Contributor();
                            project.addContributor(c);
                            while (parser.nextTag() == 2) {
                                this.unmarshallContributorDetails(parser, c);
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("dependencies")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("dependency")) {
                            d = new Dependency();
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("groupId")) {
                                    d.setGroupId(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("artifactId")) {
                                    d.setArtifactId(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("id")) {
                                    id = parser.nextText();
                                    DeprecationWarning.warn("You should be using groupId / artifactId on the Dependency - " + id);
                                    d.setId(id);
                                    continue;
                                }
                                if (parser.getName().equals("version")) {
                                    d.setVersion(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("type")) {
                                    d.setType(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("url")) {
                                    d.setUrl(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("artifact")) {
                                    d.setJar(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("jar")) {
                                    d.setJar(parser.nextText());
                                    String msg = "You should be using <artifact> tag instead of <jar> for Dependency: " + d.getJar();
                                    DeprecationWarning.warn(msg);
                                    continue;
                                }
                                if (parser.getName().equals("properties")) {
                                    while (parser.nextTag() == 2) {
                                        String pname = parser.getName();
                                        String pvalue = parser.nextText();
                                        String combinedProperty = pname + ":" + pvalue;
                                        d.addProperty(combinedProperty);
                                        d.resolvedProperties().put(pname, pvalue);
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            project.addDependency((Dependency)d);
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("build")) {
                    b = new Build();
                    project.setBuild((Build)b);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("nagEmailAddress")) {
                            b.setNagEmailAddress(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("sourceDirectory")) {
                            b.setSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("sourceModifications")) {
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("sourceModification")) {
                                    SourceModification sourceModification = new SourceModification();
                                    b.addSourceModification(sourceModification);
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("className")) {
                                            sourceModification.setClassName(parser.nextText());
                                            continue;
                                        }
                                        if (parser.getName().equals("includes")) {
                                            while (parser.nextTag() == 2) {
                                                if (parser.getName().equals("include")) {
                                                    sourceModification.addInclude(parser.nextText());
                                                    continue;
                                                }
                                                parser.nextText();
                                            }
                                            continue;
                                        }
                                        if (parser.getName().equals("excludes")) {
                                            while (parser.nextTag() == 2) {
                                                if (parser.getName().equals("exclude")) {
                                                    sourceModification.addExclude(parser.nextText());
                                                    continue;
                                                }
                                                parser.nextText();
                                            }
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        if (parser.getName().equals("aspectSourceDirectory")) {
                            b.setAspectSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("integrationUnitTestSourceDirectory")) {
                            b.setIntegrationUnitTestSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("unitTestSourceDirectory")) {
                            b.setUnitTestSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("unitTest")) {
                            UnitTest ut = new UnitTest();
                            b.setUnitTest(ut);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("includes")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("include")) {
                                            ut.addInclude(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                if (parser.getName().equals("excludes")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("exclude")) {
                                            ut.addExclude(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                if (parser.getName().equals("resources")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("resource")) {
                                            ut.addResource(this.unmarshalResource(parser));
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        if (parser.getName().equals("resources")) {
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("resource")) {
                                    b.addResource(this.unmarshalResource(parser));
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("reports")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("report")) {
                            project.addReport(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                }
            }
            eventType = parser.next();
        }
        return project;
    }

    private void unmarshallContributorDetails(XmlPullParser parser, Contributor c) throws XmlPullParserException, IOException {
        if (parser.getName().equals("name")) {
            c.setName(parser.nextText());
        } else if (parser.getName().equals("email")) {
            c.setEmail(parser.nextText());
        } else if (parser.getName().equals("organization")) {
            c.setOrganization(parser.nextText());
        } else if (parser.getName().equals("url")) {
            c.setUrl(parser.nextText());
        } else if (parser.getName().equals("timezone")) {
            c.setTimezone(parser.nextText());
        } else if (parser.getName().equals("roles")) {
            while (parser.nextTag() == 2) {
                if (parser.getName().equals("role")) {
                    c.addRole(parser.nextText());
                    continue;
                }
                parser.nextText();
            }
        } else {
            parser.nextText();
        }
    }

    protected Resource unmarshalResource(XmlPullParser parser) throws XmlPullParserException, IOException {
        Resource r = new Resource();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("directory")) {
                r.setDirectory(parser.nextText());
                continue;
            }
            if (parser.getName().equals("targetPath")) {
                r.setTargetPath(parser.nextText());
                continue;
            }
            if (parser.getName().equals("filtering")) {
                r.setFiltering(Boolean.valueOf(parser.nextText()).booleanValue());
                continue;
            }
            if (parser.getName().equals("includes")) {
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        r.addInclude(parser.nextText());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        r.addExclude(parser.nextText());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return r;
    }
}

