/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.util.IOUtil;

public final class MevenideUtils {
    private static final Log logger = LogFactory.getLog((Class)MevenideUtils.class);
    public static final String EMPTY_STR = "";
    public static final String PROPERTY_SEPARATOR = ":";

    private MevenideUtils() {
    }

    public static File normalizeFile(File file) {
        String osName = System.getProperty("os.name");
        boolean isWindows = osName.startsWith("Wind");
        if (isWindows) {
            if (file.getParent() != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    logger.warn((Object)("getCanonicalFile() on file " + file + " failed. " + e.toString()));
                    file = file.getAbsoluteFile();
                }
            } else {
                file = file.getAbsoluteFile();
            }
        } else {
            file = new File(file.toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }

    public static boolean findFile(File rootDirectory, String fileName) {
        File[] f = rootDirectory.listFiles();
        for (int i = 0; i < f.length; ++i) {
            if (!(f[i].isDirectory() ? MevenideUtils.findFile(f[i], fileName) : f[i].getName().equals(fileName))) continue;
            return true;
        }
        return false;
    }

    public static boolean notEquivalent(Object newValue, Object oldValue) {
        if (newValue == null && oldValue == null) {
            return false;
        }
        if (newValue == null) {
            return true;
        }
        return !newValue.equals(oldValue);
    }

    public static String[] resolveProperty(String property) {
        String[] parts = property.split(PROPERTY_SEPARATOR);
        String name = parts[0];
        String value = parts.length > 1 ? parts[1] : EMPTY_STR;
        return new String[]{name, value};
    }

    public static String makeRelativePath(File basedir, String path) throws IOException {
        String canonicalBasedir = basedir.getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        if (canonicalPath.equals(canonicalBasedir)) {
            return ".";
        }
        if (canonicalPath.startsWith(canonicalBasedir)) {
            canonicalPath = canonicalPath.charAt(canonicalBasedir.length()) == File.separatorChar ? canonicalPath.substring(canonicalBasedir.length() + 1) : canonicalPath.substring(canonicalBasedir.length());
        }
        return canonicalPath;
    }

    public static List asList(Map properties) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String nextKey = (String)iterator.next();
            list.add(nextKey + PROPERTY_SEPARATOR + properties.get(nextKey));
        }
        return list;
    }

    public static Properties asProperties(List properties) {
        Properties props = new Properties();
        for (int i = 0; i < properties.size(); ++i) {
            String[] resolvedProperty = MevenideUtils.resolveProperty((String)properties.get(i));
            props.put(resolvedProperty[0], resolvedProperty[1]);
        }
        return props;
    }

    public static File createFile(InputStream is) throws Exception {
        File file = File.createTempFile("pom", "template");
        IOUtil.copy(is, (OutputStream)new FileOutputStream(file));
        return file;
    }
}

