/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.Project;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.properties.IPropertyLocator;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.properties.resolver.PropertyLocatorFactory;

public final class ResolverUtils {
    private static ResolverUtils instance = new ResolverUtils();
    private Map resolvers = new HashMap();
    private Map locators = new HashMap();

    private ResolverUtils() {
    }

    public static ResolverUtils getInstance() {
        return instance;
    }

    public String resolve(Project project, String value) {
        if (value == null) {
            return value;
        }
        IPropertyResolver resolver = this.getResolver(project.getFile());
        String workingValue = value;
        String tmp = "";
        while (workingValue.indexOf("${") > -1) {
            int begin = workingValue.indexOf("${");
            tmp = tmp + workingValue.substring(0, begin);
            int end = workingValue.indexOf("}");
            if (end <= -1) continue;
            String resolved = resolver.resolveString(workingValue.substring(begin, end + 1));
            tmp = tmp + (resolved != null ? resolved : "${" + workingValue.substring(begin, end) + "}");
            workingValue = workingValue.substring(end + 1);
        }
        return tmp + workingValue;
    }

    public IPropertyResolver getResolver(File projectFile) {
        IPropertyResolver resolver = null;
        if (!this.resolvers.containsKey(projectFile)) {
            QueryContextObjects objects = this.newQueryContextObjects(projectFile);
            resolver = objects.resolver;
            this.resolvers.put(projectFile, resolver);
            this.resolvers.put(projectFile, objects.locator);
        }
        return (IPropertyResolver)this.resolvers.get(projectFile);
    }

    public IPropertyLocator getLocator(File projectFile) {
        IPropertyLocator locator = null;
        if (!this.resolvers.containsKey(projectFile)) {
            QueryContextObjects objects = this.newQueryContextObjects(projectFile);
            locator = objects.locator;
            this.locators.put(projectFile, objects.resolver);
            this.locators.put(projectFile, locator);
        }
        return (IPropertyLocator)this.locators.get(projectFile);
    }

    private QueryContextObjects newQueryContextObjects(File projectFile) {
        DefaultQueryContext queryContext = new DefaultQueryContext(projectFile.getParentFile());
        IPropertyResolver resolver = queryContext.getResolver();
        IPropertyLocator locator = PropertyLocatorFactory.getFactory().createContextBasedLocator((IQueryContext)queryContext);
        return new QueryContextObjects(resolver, locator);
    }

    private static class QueryContextObjects {
        IPropertyResolver resolver;
        IPropertyLocator locator;

        public QueryContextObjects(IPropertyResolver resolver, IPropertyLocator locator) {
            this.resolver = resolver;
            this.locator = locator;
        }
    }
}

