/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.util.monitor.Monitor;
import org.codehaus.cargo.util.monitor.SimpleMonitor;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.mevenide.netbeans.cargo.ProxyUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;

public class ContainerPanel
extends JPanel {
    private JButton btnInstallDir;
    private JCheckBox cbExisting;
    private JCheckBox cbStart;
    private JComboBox comType;
    private JPanel jPanel1;
    private JLabel lblDownloadUrl;
    private JLabel lblInstallDir;
    private JLabel lblPort;
    private JLabel lblType;
    private JTextField txtDownloadUrl;
    private JTextField txtInstallDir;
    private JTextField txtPort;

    public ContainerPanel() {
        this.initComponents();
        this.comType.setModel(new DefaultComboBoxModel<String>(CargoServerRegistry.CONTAINER_TYPES));
        this.setPreferredSize(new Dimension(500, 150));
        this.cbExisting.setSelected(true);
        this.lblDownloadUrl.setVisible(false);
        this.txtDownloadUrl.setVisible(false);
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.comType = new JComboBox();
        this.lblInstallDir = new JLabel();
        this.txtInstallDir = new JTextField();
        this.btnInstallDir = new JButton();
        this.cbStart = new JCheckBox();
        this.lblPort = new JLabel();
        this.txtPort = new JTextField();
        this.cbExisting = new JCheckBox();
        this.lblDownloadUrl = new JLabel();
        this.txtDownloadUrl = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblType.setText("Container Type");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblType, gridBagConstraints);
        this.comType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContainerPanel.this.comTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comType, gridBagConstraints);
        this.lblInstallDir.setText("Install Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblInstallDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtInstallDir, gridBagConstraints);
        this.btnInstallDir.setText("Browse...");
        this.btnInstallDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContainerPanel.this.btnInstallDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 6, 0, 6);
        this.add((Component)this.btnInstallDir, gridBagConstraints);
        this.cbStart.setText("Start Immediately");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.cbStart, gridBagConstraints);
        this.lblPort.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblPort, gridBagConstraints);
        this.txtPort.setText("8080");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtPort, gridBagConstraints);
        this.cbExisting.setText("Use existing installation");
        this.cbExisting.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.cbExisting.setMargin(new Insets(0, 0, 0, 0));
        this.cbExisting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContainerPanel.this.cbExistingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbExisting, gridBagConstraints);
        this.lblDownloadUrl.setText("Download URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblDownloadUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtDownloadUrl, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(10, 19));
        this.jPanel1.setPreferredSize(new Dimension(10, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void comTypeActionPerformed(ActionEvent evt) {
        if (!this.cbExisting.isSelected()) {
            this.txtDownloadUrl.setText(CargoServerRegistry.getInstance().getDownloadUrl((String)this.comType.getSelectedItem()));
        } else {
            this.txtDownloadUrl.setText("");
        }
    }

    private void cbExistingActionPerformed(ActionEvent evt) {
        this.lblDownloadUrl.setVisible(!this.cbExisting.isSelected());
        this.txtDownloadUrl.setVisible(!this.cbExisting.isSelected());
        if (!this.cbExisting.isSelected()) {
            this.txtDownloadUrl.setText(CargoServerRegistry.getInstance().getDownloadUrl((String)this.comType.getSelectedItem()));
        } else {
            this.txtDownloadUrl.setText("");
        }
    }

    private void btnInstallDirActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Container's Home Directory");
        chooser.setFileSelectionMode(1);
        String path = this.txtInstallDir.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.txtInstallDir.setText(projectDir.getAbsolutePath());
        }
    }

    public void createContainer() {
        StatusDisplayer.getDefault().setStatusText("Creating new Cargo Container instance.");
        CargoServerRegistry reg = CargoServerRegistry.getInstance();
        Container cont = null;
        File homeDir = null;
        cont = reg.getFactory().createContainer((String)this.comType.getSelectedItem());
        if (this.cbExisting.isSelected()) {
            homeDir = new File(this.txtInstallDir.getText());
        } else {
            StatusDisplayer.getDefault().setStatusText("Downloading server binaries...");
            try {
                URL url = new URL(this.txtDownloadUrl.getText());
                File dir = new File(this.txtInstallDir.getText());
                ZipURLInstaller installer = new ZipURLInstaller(url, dir);
                String host = ProxyUtilities.getProxyHost();
                String port = ProxyUtilities.getProxyPort();
                if (host != null && port != null && port.length() > 0 && host.length() > 0) {
                    Proxy proxy = new Proxy();
                    proxy.setHost(host);
                    proxy.setPort(Integer.parseInt(port));
                    installer.setProxy(proxy);
                }
                installer.setMonitor((Monitor)new SimpleMonitor());
                installer.install();
                homeDir = installer.getHomeDir();
            }
            catch (MalformedURLException exc) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)("Malformed URL:" + exc.getLocalizedMessage()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
        }
        if (homeDir != null && homeDir.exists()) {
            cont.setHomeDir(homeDir);
            try {
                cont.setOutput(File.createTempFile(cont.getId(), "log"));
            }
            catch (IOException exc) {
                // empty catch block
            }
            cont.setConfiguration(reg.getConfigFactory().createConfiguration(cont, "standalone"));
            cont.getConfiguration().setProperty("cargo.servlet.port", this.txtPort.getText());
            CargoServerRegistry.getInstance().addContainer(cont);
            if (this.cbStart.isSelected()) {
                reg.startContainer(cont);
            }
            StatusDisplayer.getDefault().setStatusText("Installed Cargo container.");
        } else {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Error");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

