/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.cargo.container.Container;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class ContainerPersistance {
    private static final String CARGO_ROOT = "Cargo/Containers";
    private static final String CONTAINER_TYPE = "ContainerType";
    private static final String HOME_DIR = "HomeDir";
    private static final String CONFIG_HOME_DIR = "ConfigHomeDir";
    private static final String PORT = "cargo.servlet.port";
    private static final String USERS = "cargo.servlet.users";
    private static final String HOSTNAME = "cargo.hostname";
    private static final String JVMARGS = "cargo.jvmargs";
    private static final String LOGGING = "cargo.logging";

    private ContainerPersistance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveContainers() {
        FileObject obj = Repository.getDefault().getDefaultFileSystem().findResource(CARGO_ROOT);
        try {
            if (obj == null) {
                obj = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)CARGO_ROOT);
            } else {
                obj.delete();
                obj = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)CARGO_ROOT);
            }
            FileObject[] fos = obj.getChildren();
            for (int i = 0; i < fos.length; ++i) {
                fos[i].delete();
            }
            Collection containers = CargoServerRegistry.getInstance().getContainers();
            Iterator it = containers.iterator();
            String lastName = null;
            while (it.hasNext()) {
                Container cont = (Container)it.next();
                String name = FileUtil.findFreeFileName((FileObject)obj, (String)cont.getId(), (String)"properties");
                FileObject fo = obj.createData(name);
                Properties props = new Properties();
                ContainerPersistance.putProperty(props, CONTAINER_TYPE, cont.getId());
                ContainerPersistance.putProperty(props, HOME_DIR, cont.getHomeDir().getAbsolutePath());
                ContainerPersistance.putProperty(props, CONFIG_HOME_DIR, cont.getConfiguration().getDir().getAbsolutePath());
                ContainerPersistance.putProperty(props, PORT, cont.getConfiguration().getPropertyValue(PORT));
                ContainerPersistance.putProperty(props, USERS, cont.getConfiguration().getPropertyValue(USERS));
                ContainerPersistance.putProperty(props, HOSTNAME, cont.getConfiguration().getPropertyValue(HOSTNAME));
                ContainerPersistance.putProperty(props, LOGGING, cont.getConfiguration().getPropertyValue(LOGGING));
                ContainerPersistance.putProperty(props, JVMARGS, cont.getConfiguration().getPropertyValue(JVMARGS));
                OutputStream str = null;
                FileLock lock = null;
                try {
                    lock = fo.lock();
                    str = fo.getOutputStream(lock);
                    props.store(str, null);
                }
                finally {
                    if (str != null) {
                        try {
                            str.close();
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                if (lastName != null) {
                    obj.setAttribute(lastName + "/" + name, (Object)Boolean.TRUE);
                }
                lastName = name;
            }
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
        }
    }

    private static void putProperty(Properties props, String key, String value) {
        if (value != null) {
            props.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadContainers() {
        FileObject obj = Repository.getDefault().getDefaultFileSystem().findResource(CARGO_ROOT);
        if (obj != null) {
            FileObject[] childs = obj.getChildren();
            for (int i = 0; i < childs.length; ++i) {
                Properties prop = new Properties();
                InputStream str = null;
                try {
                    str = childs[i].getInputStream();
                    prop.load(str);
                    String type = prop.getProperty(CONTAINER_TYPE);
                    CargoServerRegistry reg = CargoServerRegistry.getInstance();
                    Container cont = reg.getFactory().createContainer(type);
                    cont.setHomeDir(prop.getProperty(HOME_DIR));
                    cont.setOutput(File.createTempFile(cont.getId(), "log"));
                    cont.setConfiguration(reg.getConfigFactory().createConfiguration(cont, "standalone"));
                    cont.getConfiguration().setProperty(PORT, prop.getProperty(PORT));
                    cont.getConfiguration().setProperty(USERS, prop.getProperty(USERS));
                    cont.getConfiguration().setProperty(HOSTNAME, prop.getProperty(HOSTNAME));
                    cont.getConfiguration().setProperty(LOGGING, prop.getProperty(LOGGING));
                    cont.getConfiguration().setProperty(JVMARGS, prop.getProperty(JVMARGS));
                    reg.addContainer(cont);
                    continue;
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    continue;
                }
                finally {
                    if (str != null) {
                        try {
                            str.close();
                        }
                        catch (IOException x) {}
                    }
                }
            }
        }
    }
}

