/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ViewLogAction
extends AbstractAction {
    private File file;
    private String tabName;
    private InputOutput io;

    public ViewLogAction(File logFile, String name, String tabName) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/cargo/resources/RefreshIcon.gif")));
        this.putValue("ShortDescription", "Refresh Log View");
        this.file = logFile;
        this.tabName = tabName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.io == null) {
            this.io = IOProvider.getDefault().getIO(this.tabName, new Action[]{this});
        }
        BufferedReader reader = null;
        try {
            this.io.getOut().reset();
            this.io.select();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            String line = reader.readLine();
            while (line != null) {
                this.io.getOut().println(line);
                line = reader.readLine();
            }
        }
        catch (IOException exc) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (this.io != null) {
                    this.io.getOut().close();
                    this.io.getErr().close();
                }
            }
            catch (IOException exc) {}
        }
    }
}

