/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerFactory;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationFactory;
import org.codehaus.cargo.container.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.container.configuration.StandaloneConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableFactory;
import org.codehaus.cargo.container.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerFactory;
import org.codehaus.cargo.container.spi.DefaultDeployableFactory;
import org.codehaus.cargo.util.monitor.FileMonitor;
import org.codehaus.cargo.util.monitor.Monitor;
import org.codehaus.cargo.util.monitor.NullMonitor;
import org.mevenide.netbeans.cargo.RegistryEvent;
import org.mevenide.netbeans.cargo.RegistryListener;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class CargoServerRegistry {
    public static String[] CONTAINER_TYPES = new String[]{"resin2x", "resin3x", "orion1x", "orion2x", "oc4j9x", "tomcat3x", "tomcat4x", "tomcat5x", "weblogic8x", "jo1x"};
    private HashMap installUrls;
    private Collection running;
    private HashMap deployables;
    private HashMap deployers;
    private ArrayList listeners;
    private Monitor monitor;
    private File monitorFile;
    private RequestProcessor processor;
    private ContainerFactory factory;
    private ConfigurationFactory configFactory;
    private DeployableFactory deployableFactory;
    private DeployerFactory deployerFactory;
    private Collection dynamicContainers = new ArrayList();
    private static CargoServerRegistry instance;

    private CargoServerRegistry() {
        this.dynamicContainers.add("resin2x");
        this.dynamicContainers.add("resin3x");
        this.dynamicContainers.add("jo1x");
        this.installUrls = new HashMap();
        this.installUrls.put("resin2x", "http://www.caucho.com/download/resin-2.1.14.zip");
        this.installUrls.put("resin3x", "http://www.caucho.com/download/resin-3.0.9.zip");
        this.installUrls.put("orion1x", "http://www.orionserver.com/distributions/orion1.6.0b.zip");
        this.installUrls.put("orion2x", "http://www.orionserver.com/distributions/orion2.0.5.zip");
        this.installUrls.put("tomcat3x", "http://www.apache.org/dist/jakarta/tomcat-3/v3.3.2/bin/jakarta-tomcat-3.3.2.zip");
        this.installUrls.put("tomcat4x", "http://www.apache.org/dist/jakarta/tomcat-4/v4.1.31/bin/jakarta-tomcat-4.1.31.zip");
        this.installUrls.put("tomcat5x", "http://www.apache.org/dist/jakarta/tomcat-5/v5.0.30/bin/jakarta-tomcat-5.0.30.zip");
        this.processor = new RequestProcessor("Cargo Containers", 10);
        this.factory = new ContainerFactory();
        this.configFactory = new DefaultConfigurationFactory();
        this.deployableFactory = new DefaultDeployableFactory();
        this.deployerFactory = new DefaultDeployerFactory();
        try {
            this.monitorFile = File.createTempFile("cargo", "log");
            this.monitor = new FileMonitor(this.monitorFile, false);
        }
        catch (IOException exc) {
            this.monitor = new NullMonitor();
        }
        this.running = new ArrayList();
        this.deployers = new HashMap();
        this.deployables = new HashMap();
        this.listeners = new ArrayList();
    }

    public static synchronized CargoServerRegistry getInstance() {
        if (instance == null) {
            instance = new CargoServerRegistry();
        }
        return instance;
    }

    public ContainerFactory getFactory() {
        return this.factory;
    }

    public ConfigurationFactory getConfigFactory() {
        return this.configFactory;
    }

    public DeployableFactory getDeployableFactory() {
        return this.deployableFactory;
    }

    public synchronized Deployer getDeployer(Container container) {
        Deployer toRet = (Deployer)this.deployers.get(container);
        if (toRet == null) {
            toRet = this.deployerFactory.createDeployer(container, "default");
            this.deployers.put(container, toRet);
        }
        return toRet;
    }

    public synchronized void registerDeployable(Container container, Deployable deploy) {
        HashSet<Deployable> col = (HashSet<Deployable>)this.deployables.get(container);
        if (col == null) {
            col = new HashSet<Deployable>();
            this.deployables.put(container, col);
        }
        col.add(deploy);
        this.fireDeployablesChanged(container);
    }

    public synchronized Deployable[] findDeployables(String path) {
        Iterator it = this.running.iterator();
        File fil = new File(path);
        ArrayList<Deployable> toRet = new ArrayList<Deployable>();
        while (it.hasNext()) {
            Container cont = (Container)it.next();
            Iterator it2 = this.getDeployables(cont).iterator();
            while (it2.hasNext()) {
                Deployable dep = (Deployable)it2.next();
                if (dep.getFile() == null || !fil.equals(dep.getFile())) continue;
                toRet.add(dep);
            }
        }
        Deployable[] arr = toRet.toArray(new Deployable[toRet.size()]);
        return arr;
    }

    public synchronized Container findContainerForDeployable(Deployable deployable) {
        Iterator it = this.running.iterator();
        while (it.hasNext()) {
            Container cont = (Container)it.next();
            Collection col = this.getDeployables(cont);
            if (!col.contains(deployable)) continue;
            return cont;
        }
        return null;
    }

    public Collection getDeployables(Container container) {
        Collection dynam;
        StandaloneConfiguration conf;
        List stat;
        ArrayList col = new ArrayList();
        if (container.getConfiguration() instanceof StandaloneConfiguration && (stat = (conf = (StandaloneConfiguration)container.getConfiguration()).getDeployables()) != null) {
            col.addAll(stat);
        }
        if ((dynam = (Collection)this.deployables.get(container)) != null) {
            col.addAll(dynam);
        }
        return col;
    }

    public File getMonitorFile() {
        return this.monitorFile;
    }

    public boolean supportsDynamicDeployment(Container cont) {
        return this.dynamicContainers.contains(cont.getId());
    }

    public synchronized void addContainer(Container cont) {
        if (this.running.contains(cont)) {
            return;
        }
        this.running.add(cont);
        cont.setMonitor(this.monitor);
        this.fireAdded(cont);
    }

    public void startContainer(Container cont) {
        this.startContainer(cont, true);
    }

    public void startContainer(final Container cont, boolean post) {
        if (!this.getContainers().contains(cont)) {
            throw new IllegalStateException();
        }
        if (post) {
            this.processor.post(new Runnable(){

                public void run() {
                    CargoServerRegistry.this.doStart(cont);
                }
            });
        } else {
            this.doStart(cont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(Container cont) {
        this.fireChange(cont, new RegistryEvent(cont, State.STARTING));
        try {
            cont.start();
        }
        catch (ContainerException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        finally {
            this.fireChange(cont);
        }
    }

    public void stopContainer(Container cont) {
        this.stopContainer(cont, true);
    }

    public void stopContainer(final Container cont, boolean post) {
        if (!this.getContainers().contains(cont)) {
            throw new IllegalStateException();
        }
        if (post) {
            this.processor.post(new Runnable(){

                public void run() {
                    CargoServerRegistry.this.doStop(cont);
                }
            });
        } else {
            this.doStop(cont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop(Container cont) {
        this.fireChange(cont, new RegistryEvent(cont, State.STOPPING));
        try {
            cont.stop();
        }
        catch (ContainerException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        finally {
            this.fireChange(cont);
        }
    }

    public synchronized void removeContainer(Container cont) {
        if (!this.running.contains(cont)) {
            throw new IllegalStateException();
        }
        if (cont.getState() != State.STOPPED) {
            this.stopContainer(cont);
        }
        this.running.remove(cont);
        this.fireRemoved(cont);
    }

    public synchronized Collection getContainers() {
        return Collections.unmodifiableCollection(this.running);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryListener(RegistryListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryListener(RegistryListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAdded(Container cont) {
        ArrayList lst = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            lst = new ArrayList(this.listeners);
        }
        RegistryEvent evnt = new RegistryEvent(cont);
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            RegistryListener listener = (RegistryListener)it.next();
            listener.containerAdded(evnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoved(Container cont) {
        ArrayList lst = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            lst = new ArrayList(this.listeners);
        }
        RegistryEvent evnt = new RegistryEvent(cont);
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            RegistryListener listener = (RegistryListener)it.next();
            listener.containerRemoved(evnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(Container cont, RegistryEvent evnt) {
        ArrayList lst = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            lst = new ArrayList(this.listeners);
        }
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            RegistryListener listener = (RegistryListener)it.next();
            listener.stateChanged(evnt);
        }
    }

    private void fireChange(Container cont) {
        RegistryEvent evnt = new RegistryEvent(cont);
        this.fireChange(cont, evnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeployablesChanged(Container cont) {
        ArrayList lst = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            lst = new ArrayList(this.listeners);
        }
        RegistryEvent evnt = new RegistryEvent(cont);
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            RegistryListener listener = (RegistryListener)it.next();
            listener.containerDeployablesChanged(evnt);
        }
    }
}

