/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mil.nga.proj.Projection;

public class AuthorityProjections {
    private final String authority;
    private Map<String, Projection> projections = new HashMap<String, Projection>();

    public AuthorityProjections(String authority) {
        this.authority = authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public Projection getProjection(long code) {
        return this.getProjection(String.valueOf(code));
    }

    public Projection getProjection(String code) {
        return this.projections.get(code.toUpperCase());
    }

    public boolean hasProjection(Projection projection) {
        return this.hasProjection(projection.getCode());
    }

    public boolean hasProjection(long code) {
        return this.hasProjection(String.valueOf(code));
    }

    public boolean hasProjection(String code) {
        return this.getProjection(code) != null;
    }

    public void addProjection(Projection projection) {
        this.projections.put(projection.getCode().toUpperCase(), projection);
    }

    public void clear() {
        this.projections.clear();
    }

    public void remove(long code) {
        this.remove(String.valueOf(code));
    }

    public void remove(String code) {
        this.projections.remove(code.toUpperCase());
    }

    public void remove(Projection projection) {
        this.remove(projection.getCode());
    }

    public int count() {
        return this.projections.size();
    }

    public boolean isEmpty() {
        return this.projections.isEmpty();
    }

    public Set<String> getCodes() {
        return this.projections.keySet();
    }

    public Collection<Projection> getProjections() {
        return this.projections.values();
    }
}

