/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Curve;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.sweep.ShamosHoey;

public class LineString
extends Curve {
    private static final long serialVersionUID = 1L;
    private List<Point> points = new ArrayList<Point>();

    public LineString() {
        this(false, false);
    }

    public LineString(boolean hasZ, boolean hasM) {
        super(GeometryType.LINESTRING, hasZ, hasM);
    }

    public LineString(List<Point> points) {
        this(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
        this.setPoints(points);
    }

    public LineString(LineString lineString) {
        this(lineString.hasZ(), lineString.hasM());
        for (Point point : lineString.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    protected LineString(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public void addPoints(List<Point> points) {
        this.points.addAll(points);
    }

    public int numPoints() {
        return this.points.size();
    }

    public Point getPoint(int n) {
        return this.points.get(n);
    }

    @Override
    public Point startPoint() {
        Point startPoint = null;
        if (!this.isEmpty()) {
            startPoint = this.points.get(0);
        }
        return startPoint;
    }

    @Override
    public Point endPoint() {
        Point endPoint = null;
        if (!this.isEmpty()) {
            endPoint = this.points.get(this.points.size() - 1);
        }
        return endPoint;
    }

    @Override
    public boolean isSimple() {
        return ShamosHoey.simplePolygonPoints(this.points);
    }

    @Override
    public Geometry copy() {
        return new LineString(this);
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineString other = (LineString)obj;
        return !(this.points == null ? other.points != null : !this.points.equals(other.points));
    }
}

