/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.List;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.sweep.ShamosHoey;

public class Polygon
extends CurvePolygon<LineString> {
    private static final long serialVersionUID = 1L;

    public Polygon() {
        this(false, false);
    }

    public Polygon(boolean hasZ, boolean hasM) {
        super(GeometryType.POLYGON, hasZ, hasM);
    }

    public Polygon(List<LineString> rings) {
        this(GeometryUtils.hasZ(rings), GeometryUtils.hasM(rings));
        this.setRings(rings);
    }

    public Polygon(LineString ring) {
        this(ring.hasZ(), ring.hasM());
        this.addRing(ring);
    }

    public Polygon(Polygon polygon) {
        this(polygon.hasZ(), polygon.hasM());
        for (LineString ring : polygon.getRings()) {
            this.addRing((LineString)ring.copy());
        }
    }

    protected Polygon(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    @Override
    public Geometry copy() {
        return new Polygon(this);
    }

    @Override
    public boolean isSimple() {
        return ShamosHoey.simplePolygon(this);
    }
}

