/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.geojson.Position;
import mil.nga.sf.util.GeometryUtils;

public class MultiLineString
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 1L;
    private mil.nga.sf.MultiLineString multiLineString;

    public MultiLineString() {
    }

    public MultiLineString(List<List<Position>> positions) {
        this.setCoordinates(positions);
    }

    public MultiLineString(mil.nga.sf.MultiLineString multiLineString) {
        this.multiLineString = multiLineString;
    }

    public List<List<Position>> getCoordinates() {
        ArrayList<List<Position>> result = new ArrayList<List<Position>>();
        for (LineString lineString : this.multiLineString.getGeometries()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (Point point : lineString.getPoints()) {
                positions.add(new Position(point));
            }
            result.add(positions);
        }
        return result;
    }

    private void setCoordinates(List<List<Position>> positionList) {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (List<Position> lineStringPositions : positionList) {
            ArrayList<Point> positions = new ArrayList<Point>();
            for (Position position : lineStringPositions) {
                positions.add(position.toSimplePoint());
            }
            LineString lineString = new LineString(GeometryUtils.hasZ(positions), GeometryUtils.hasM(positions));
            lineString.setPoints(positions);
            lineStrings.add(lineString);
        }
        if (this.multiLineString == null) {
            this.multiLineString = new mil.nga.sf.MultiLineString(lineStrings);
        } else {
            this.multiLineString.setGeometries(lineStrings);
        }
    }

    @Override
    public Geometry getGeometry() {
        return this.multiLineString;
    }

    @Override
    public String getType() {
        return "MultiLineString";
    }
}

