/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkb;

import java.io.IOException;
import java.nio.ByteOrder;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.ByteReader;
import mil.nga.sf.util.SFException;
import mil.nga.sf.util.filter.GeometryFilter;
import mil.nga.sf.wkb.GeometryCodes;
import mil.nga.sf.wkb.GeometryTypeInfo;

public class GeometryReader {
    private static final long WKB25D = Long.decode("0x80000000");
    private ByteReader reader;

    public static Geometry readGeometry(byte[] bytes) throws IOException {
        return GeometryReader.readGeometry(bytes, null, null);
    }

    public static Geometry readGeometry(byte[] bytes, GeometryFilter filter) throws IOException {
        return GeometryReader.readGeometry(bytes, filter, null);
    }

    public static <T extends Geometry> T readGeometry(byte[] bytes, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(bytes, null, expectedType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Geometry> T readGeometry(byte[] bytes, GeometryFilter filter, Class<T> expectedType) throws IOException {
        T geometry = null;
        try (GeometryReader reader = new GeometryReader(bytes);){
            geometry = reader.read(filter, expectedType);
        }
        return geometry;
    }

    public GeometryReader(byte[] bytes) {
        this(new ByteReader(bytes));
    }

    public GeometryReader(ByteReader reader) {
        this.reader = reader;
    }

    public ByteReader getByteReader() {
        return this.reader;
    }

    public void close() {
        this.reader.close();
    }

    public Geometry read() throws IOException {
        return this.read(null, null);
    }

    public Geometry read(GeometryFilter filter) throws IOException {
        return this.read(filter, null);
    }

    public <T extends Geometry> T read(Class<T> expectedType) throws IOException {
        return this.read(null, expectedType);
    }

    public <T extends Geometry> T read(GeometryFilter filter, Class<T> expectedType) throws IOException {
        return this.read(filter, null, expectedType);
    }

    public <T extends Geometry> T read(GeometryFilter filter, GeometryType containingType, Class<T> expectedType) throws IOException {
        ByteOrder originalByteOrder = this.reader.getByteOrder();
        GeometryTypeInfo geometryTypeInfo = this.readGeometryType();
        GeometryType geometryType = geometryTypeInfo.getGeometryType();
        boolean hasZ = geometryTypeInfo.hasZ();
        boolean hasM = geometryTypeInfo.hasM();
        PolyhedralSurface geometry = null;
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                geometry = this.readPoint(hasZ, hasM);
                break;
            }
            case LINESTRING: {
                geometry = this.readLineString(filter, hasZ, hasM);
                break;
            }
            case POLYGON: {
                geometry = this.readPolygon(filter, hasZ, hasM);
                break;
            }
            case MULTIPOINT: {
                geometry = this.readMultiPoint(filter, hasZ, hasM);
                break;
            }
            case MULTILINESTRING: {
                geometry = this.readMultiLineString(filter, hasZ, hasM);
                break;
            }
            case MULTIPOLYGON: {
                geometry = this.readMultiPolygon(filter, hasZ, hasM);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                geometry = this.readGeometryCollection(filter, hasZ, hasM);
                break;
            }
            case CIRCULARSTRING: {
                geometry = this.readCircularString(filter, hasZ, hasM);
                break;
            }
            case COMPOUNDCURVE: {
                geometry = this.readCompoundCurve(filter, hasZ, hasM);
                break;
            }
            case CURVEPOLYGON: {
                geometry = this.readCurvePolygon(filter, hasZ, hasM);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                geometry = this.readPolyhedralSurface(filter, hasZ, hasM);
                break;
            }
            case TIN: {
                geometry = this.readTIN(filter, hasZ, hasM);
                break;
            }
            case TRIANGLE: {
                geometry = this.readTriangle(filter, hasZ, hasM);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
        if (!GeometryReader.filter(filter, containingType, (Geometry)geometry)) {
            geometry = null;
        }
        if (expectedType != null && geometry != null && !expectedType.isAssignableFrom(geometry.getClass())) {
            throw new SFException("Unexpected Geometry Type. Expected: " + expectedType.getSimpleName() + ", Actual: " + geometry.getClass().getSimpleName());
        }
        this.reader.setByteOrder(originalByteOrder);
        PolyhedralSurface result = geometry;
        return (T)result;
    }

    public GeometryTypeInfo readGeometryType() throws IOException {
        byte byteOrderValue = this.reader.readByte();
        ByteOrder byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.reader.setByteOrder(byteOrder);
        long unsignedGeometryTypeCode = this.reader.readUnsignedInt();
        boolean hasZ = false;
        if (unsignedGeometryTypeCode > WKB25D) {
            hasZ = true;
            unsignedGeometryTypeCode -= WKB25D;
        }
        int geometryTypeCode = (int)unsignedGeometryTypeCode;
        GeometryType geometryType = GeometryCodes.getGeometryType(geometryTypeCode);
        if (!hasZ) {
            hasZ = GeometryCodes.hasZ(geometryTypeCode);
        }
        boolean hasM = GeometryCodes.hasM(geometryTypeCode);
        GeometryTypeInfo geometryInfo = new GeometryTypeInfo(geometryTypeCode, geometryType, hasZ, hasM);
        return geometryInfo;
    }

    public Point readPoint(boolean hasZ, boolean hasM) throws IOException {
        double x = this.reader.readDouble();
        double y = this.reader.readDouble();
        Point point = new Point(hasZ, hasM, x, y);
        if (hasZ) {
            double z = this.reader.readDouble();
            point.setZ(Double.valueOf(z));
        }
        if (hasM) {
            double m = this.reader.readDouble();
            point.setM(Double.valueOf(m));
        }
        return point;
    }

    public LineString readLineString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readLineString(filter, hasZ, hasM);
    }

    public LineString readLineString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        LineString lineString = new LineString(hasZ, hasM);
        int numPoints = this.reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = this.readPoint(hasZ, hasM);
            if (!GeometryReader.filter(filter, GeometryType.LINESTRING, (Geometry)point)) continue;
            lineString.addPoint(point);
        }
        return lineString;
    }

    public Polygon readPolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readPolygon(filter, hasZ, hasM);
    }

    public Polygon readPolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        Polygon polygon = new Polygon(hasZ, hasM);
        int numRings = this.reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = this.readLineString(filter, hasZ, hasM);
            if (!GeometryReader.filter(filter, GeometryType.POLYGON, (Geometry)ring)) continue;
            polygon.addRing((Curve)ring);
        }
        return polygon;
    }

    public MultiPoint readMultiPoint(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiPoint(filter, hasZ, hasM);
    }

    public MultiPoint readMultiPoint(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiPoint multiPoint = new MultiPoint(hasZ, hasM);
        int numPoints = this.reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = this.read(filter, GeometryType.MULTIPOINT, Point.class);
            if (point == null) continue;
            multiPoint.addPoint(point);
        }
        return multiPoint;
    }

    public MultiLineString readMultiLineString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiLineString(filter, hasZ, hasM);
    }

    public MultiLineString readMultiLineString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiLineString multiLineString = new MultiLineString(hasZ, hasM);
        int numLineStrings = this.reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = this.read(filter, GeometryType.MULTILINESTRING, LineString.class);
            if (lineString == null) continue;
            multiLineString.addLineString(lineString);
        }
        return multiLineString;
    }

    public MultiPolygon readMultiPolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiPolygon(filter, hasZ, hasM);
    }

    public MultiPolygon readMultiPolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiPolygon multiPolygon = new MultiPolygon(hasZ, hasM);
        int numPolygons = this.reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = this.read(filter, GeometryType.MULTIPOLYGON, Polygon.class);
            if (polygon == null) continue;
            multiPolygon.addPolygon(polygon);
        }
        return multiPolygon;
    }

    public GeometryCollection<Geometry> readGeometryCollection(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readGeometryCollection(filter, hasZ, hasM);
    }

    public GeometryCollection<Geometry> readGeometryCollection(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryCollection geometryCollection = new GeometryCollection(hasZ, hasM);
        int numGeometries = this.reader.readInt();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometry = this.read(filter, GeometryType.GEOMETRYCOLLECTION, Geometry.class);
            if (geometry == null) continue;
            geometryCollection.addGeometry(geometry);
        }
        return geometryCollection;
    }

    public CircularString readCircularString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCircularString(filter, hasZ, hasM);
    }

    public CircularString readCircularString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CircularString circularString = new CircularString(hasZ, hasM);
        int numPoints = this.reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = this.readPoint(hasZ, hasM);
            if (!GeometryReader.filter(filter, GeometryType.CIRCULARSTRING, (Geometry)point)) continue;
            circularString.addPoint(point);
        }
        return circularString;
    }

    public CompoundCurve readCompoundCurve(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCompoundCurve(filter, hasZ, hasM);
    }

    public CompoundCurve readCompoundCurve(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CompoundCurve compoundCurve = new CompoundCurve(hasZ, hasM);
        int numLineStrings = this.reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = this.read(filter, GeometryType.COMPOUNDCURVE, LineString.class);
            if (lineString == null) continue;
            compoundCurve.addLineString(lineString);
        }
        return compoundCurve;
    }

    public CurvePolygon<Curve> readCurvePolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCurvePolygon(filter, hasZ, hasM);
    }

    public CurvePolygon<Curve> readCurvePolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CurvePolygon curvePolygon = new CurvePolygon(hasZ, hasM);
        int numRings = this.reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            Curve ring = this.read(filter, GeometryType.CURVEPOLYGON, Curve.class);
            if (ring == null) continue;
            curvePolygon.addRing(ring);
        }
        return curvePolygon;
    }

    public PolyhedralSurface readPolyhedralSurface(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readPolyhedralSurface(filter, hasZ, hasM);
    }

    public PolyhedralSurface readPolyhedralSurface(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        PolyhedralSurface polyhedralSurface = new PolyhedralSurface(hasZ, hasM);
        int numPolygons = this.reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = this.read(filter, GeometryType.POLYHEDRALSURFACE, Polygon.class);
            if (polygon == null) continue;
            polyhedralSurface.addPolygon(polygon);
        }
        return polyhedralSurface;
    }

    public TIN readTIN(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readTIN(filter, hasZ, hasM);
    }

    public TIN readTIN(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        TIN tin = new TIN(hasZ, hasM);
        int numPolygons = this.reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = this.read(filter, GeometryType.TIN, Polygon.class);
            if (polygon == null) continue;
            tin.addPolygon(polygon);
        }
        return tin;
    }

    public Triangle readTriangle(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readTriangle(filter, hasZ, hasM);
    }

    public Triangle readTriangle(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        Triangle triangle = new Triangle(hasZ, hasM);
        int numRings = this.reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = this.readLineString(filter, hasZ, hasM);
            if (!GeometryReader.filter(filter, GeometryType.TRIANGLE, (Geometry)ring)) continue;
            triangle.addRing((Curve)ring);
        }
        return triangle;
    }

    public static Geometry readGeometry(ByteReader reader) throws IOException {
        return GeometryReader.readGeometry(reader, null, null);
    }

    public static Geometry readGeometry(ByteReader reader, GeometryFilter filter) throws IOException {
        return GeometryReader.readGeometry(reader, filter, null);
    }

    public static <T extends Geometry> T readGeometry(ByteReader reader, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(reader, null, expectedType);
    }

    public static <T extends Geometry> T readGeometry(ByteReader reader, GeometryFilter filter, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(reader, filter, null, expectedType);
    }

    public static <T extends Geometry> T readGeometry(ByteReader reader, GeometryFilter filter, GeometryType containingType, Class<T> expectedType) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.read(filter, containingType, expectedType);
    }

    public static GeometryTypeInfo readGeometryType(ByteReader reader) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryType();
    }

    public static Point readPoint(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPoint(hasZ, hasM);
    }

    public static LineString readLineString(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readLineString(hasZ, hasM);
    }

    public static LineString readLineString(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readLineString(filter, hasZ, hasM);
    }

    public static Polygon readPolygon(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolygon(hasZ, hasM);
    }

    public static Polygon readPolygon(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolygon(filter, hasZ, hasM);
    }

    public static MultiPoint readMultiPoint(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPoint(hasZ, hasM);
    }

    public static MultiPoint readMultiPoint(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPoint(filter, hasZ, hasM);
    }

    public static MultiLineString readMultiLineString(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiLineString(hasZ, hasM);
    }

    public static MultiLineString readMultiLineString(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiLineString(filter, hasZ, hasM);
    }

    public static MultiPolygon readMultiPolygon(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPolygon(hasZ, hasM);
    }

    public static MultiPolygon readMultiPolygon(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPolygon(filter, hasZ, hasM);
    }

    public static GeometryCollection<Geometry> readGeometryCollection(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryCollection(hasZ, hasM);
    }

    public static GeometryCollection<Geometry> readGeometryCollection(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryCollection(filter, hasZ, hasM);
    }

    public static CircularString readCircularString(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCircularString(hasZ, hasM);
    }

    public static CircularString readCircularString(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCircularString(filter, hasZ, hasM);
    }

    public static CompoundCurve readCompoundCurve(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCompoundCurve(hasZ, hasM);
    }

    public static CompoundCurve readCompoundCurve(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCompoundCurve(filter, hasZ, hasM);
    }

    public static CurvePolygon<Curve> readCurvePolygon(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCurvePolygon(hasZ, hasM);
    }

    public static CurvePolygon<Curve> readCurvePolygon(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCurvePolygon(filter, hasZ, hasM);
    }

    public static PolyhedralSurface readPolyhedralSurface(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolyhedralSurface(hasZ, hasM);
    }

    public static PolyhedralSurface readPolyhedralSurface(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolyhedralSurface(filter, hasZ, hasM);
    }

    public static TIN readTIN(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTIN(hasZ, hasM);
    }

    public static TIN readTIN(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTIN(filter, hasZ, hasM);
    }

    public static Triangle readTriangle(ByteReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTriangle(hasZ, hasM);
    }

    public static Triangle readTriangle(ByteReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTriangle(filter, hasZ, hasM);
    }

    private static boolean filter(GeometryFilter filter, GeometryType containingType, Geometry geometry) {
        return filter == null || geometry == null || filter.filter(containingType, geometry);
    }
}

