/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static int COPY_BUFFER_SIZE = 8192;

    public static void copyFile(File copyFrom, File copyTo) throws IOException {
        FileInputStream from = new FileInputStream(copyFrom);
        FileOutputStream to = new FileOutputStream(copyTo);
        IOUtils.copyStream((InputStream)from, to);
    }

    public static void copyStream(InputStream copyFrom, File copyTo) throws IOException {
        FileOutputStream to = new FileOutputStream(copyTo);
        IOUtils.copyStream(copyFrom, to);
    }

    public static byte[] fileBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return IOUtils.streamBytes(fis);
    }

    public static byte[] streamBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copyStream(stream, bytes);
        return bytes.toByteArray();
    }

    public static void copyStream(InputStream copyFrom, OutputStream copyTo) throws IOException {
        int length;
        byte[] buffer = new byte[COPY_BUFFER_SIZE];
        while ((length = copyFrom.read(buffer)) > 0) {
            copyTo.write(buffer, 0, length);
        }
        copyTo.flush();
        copyTo.close();
        copyFrom.close();
    }
}

