/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import java.util.Locale;

public enum GeometryType {
    GEOMETRY(0),
    POINT(1),
    LINESTRING(2),
    POLYGON(3),
    MULTIPOINT(4),
    MULTILINESTRING(5),
    MULTIPOLYGON(6),
    GEOMETRYCOLLECTION(7),
    CIRCULARSTRING(8),
    COMPOUNDCURVE(9),
    CURVEPOLYGON(10),
    MULTICURVE(11),
    MULTISURFACE(12),
    CURVE(13),
    SURFACE(14),
    POLYHEDRALSURFACE(15),
    TIN(16),
    TRIANGLE(17);

    private final int code;

    private GeometryType(int code) {
        this.code = code;
    }

    public String getName() {
        return this.name();
    }

    public int getCode() {
        return this.code;
    }

    public static GeometryType fromCode(int code) {
        GeometryType geometryType = null;
        switch (code) {
            case 0: {
                geometryType = GEOMETRY;
                break;
            }
            case 1: {
                geometryType = POINT;
                break;
            }
            case 2: {
                geometryType = LINESTRING;
                break;
            }
            case 3: {
                geometryType = POLYGON;
                break;
            }
            case 4: {
                geometryType = MULTIPOINT;
                break;
            }
            case 5: {
                geometryType = MULTILINESTRING;
                break;
            }
            case 6: {
                geometryType = MULTIPOLYGON;
                break;
            }
            case 7: {
                geometryType = GEOMETRYCOLLECTION;
                break;
            }
            case 8: {
                geometryType = CIRCULARSTRING;
                break;
            }
            case 9: {
                geometryType = COMPOUNDCURVE;
                break;
            }
            case 10: {
                geometryType = CURVEPOLYGON;
                break;
            }
            case 11: {
                geometryType = MULTICURVE;
                break;
            }
            case 12: {
                geometryType = MULTISURFACE;
                break;
            }
            case 13: {
                geometryType = CURVE;
                break;
            }
            case 14: {
                geometryType = SURFACE;
                break;
            }
            case 15: {
                geometryType = POLYHEDRALSURFACE;
                break;
            }
            case 16: {
                geometryType = TIN;
                break;
            }
            case 17: {
                geometryType = TRIANGLE;
            }
        }
        return geometryType;
    }

    public static GeometryType fromName(String name) {
        return GeometryType.valueOf(name.toUpperCase(Locale.US));
    }
}

