/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ContainerRequest;
import org.milyn.device.ident.UnknownDeviceException;
import org.milyn.logging.SmooksLogger;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.servlet.container.HttpServletContainerRequest;
import org.milyn.servlet.container.ServletContainerContext;
import org.milyn.servlet.delivery.ServletResponseWrapper;
import org.milyn.servlet.delivery.ServletResponseWrapperFactory;
import org.milyn.servlet.delivery.XMLServletResponseWrapper;

public class SmooksServletFilter
implements Filter {
    private static final String SMOOKS_CDRAR_LIST_CONFIG_PARAM = "SmooksCdrarListUrl";
    private static final String DEFAULT_CONFIG = "/smooks-cdr.lst";
    private ServletContainerContext smooksContainerContext;
    private FilterToServletConfigAdapter servletConfig;
    private Log logger = SmooksLogger.getLog();

    public void init(FilterConfig config) throws ServletException {
        try {
            this.servletConfig = new FilterToServletConfigAdapter(config);
            this.smooksContainerContext = new ServletContainerContext(config.getServletContext(), this.servletConfig);
            this.loadCdrarStore();
            this.logger.info((Object)"Smooks Servlet Filter initalised.");
        }
        catch (Exception e) {
            throw new ServletException("CDRArchive list load failure.", (Throwable)e);
        }
    }

    private void loadCdrarStore() throws IllegalArgumentException, IOException {
        ContainerResourceLocator containerResLocator = this.smooksContainerContext.getResourceLocator();
        InputStream cdrarListStream = containerResLocator.getResource(SMOOKS_CDRAR_LIST_CONFIG_PARAM, DEFAULT_CONFIG);
        BufferedReader listBufferedReader = new BufferedReader(new InputStreamReader(cdrarListStream));
        this.smooksContainerContext.getStore().load(listBufferedReader);
        this.logger.info((Object)"CDRStore load complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ServletResponseWrapper responseWrapper = null;
        try {
            long startTime = 0L;
            HttpServletContainerRequest containerRequest = new HttpServletContainerRequest((HttpServletRequest)request, this.servletConfig, this.smooksContainerContext);
            if (this.logger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((responseWrapper = this.getResponseWrapper(request.getParameter("smooksrw"), response, containerRequest)) == null) {
                responseWrapper = this.getResponseWrapper("html-smooksrw", response, containerRequest);
            }
            if (responseWrapper == null) {
                responseWrapper = new XMLServletResponseWrapper(containerRequest, (HttpServletResponse)response);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying response wrapper [" + ((Object)((Object)responseWrapper)).getClass() + "] to request [" + ((HttpServletRequest)request).getRequestURI() + "]."));
            }
            filterChain.doFilter(request, (ServletResponse)responseWrapper);
            responseWrapper.deliverResponse();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[doFilter] " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (UnknownDeviceException e) {
            this.logger.error((Object)"Unknown Device.  Smooks not being used to deliver content.", (Throwable)e);
            filterChain.doFilter(request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (responseWrapper != null) {
                responseWrapper.close();
            }
        }
    }

    private ServletResponseWrapper getResponseWrapper(String selector, ServletResponse response, ContainerRequest containerRequest) {
        List resourceConfigList;
        ServletResponseWrapper responseWrapper = null;
        if (selector != null && (resourceConfigList = containerRequest.getDeliveryConfig().getSmooksResourceConfigurations(selector)) != null && !resourceConfigList.isEmpty()) {
            responseWrapper = ServletResponseWrapperFactory.createServletResponseWrapper((SmooksResourceConfiguration)resourceConfigList.get(0), containerRequest, (HttpServletResponse)response);
        }
        return responseWrapper;
    }

    public void destroy() {
    }

    private class FilterToServletConfigAdapter
    implements ServletConfig {
        private FilterConfig config;

        private FilterToServletConfigAdapter(FilterConfig config) {
            this.config = config;
        }

        public String getServletName() {
            return this.config.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return this.config.getInitParameter(paramName);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }
    }
}

