/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.container;

import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.milyn.container.ContainerContext;
import org.milyn.container.ContainerRequest;
import org.milyn.container.ContainerSession;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryConfigImpl;
import org.milyn.delivery.ElementList;
import org.milyn.device.UAContext;
import org.milyn.device.ident.UnknownDeviceException;
import org.milyn.servlet.ServletUAContext;
import org.milyn.servlet.container.HttpServletContainerSession;
import org.milyn.servlet.container.ServletContainerContext;

public class HttpServletContainerRequest
implements ContainerRequest {
    private HttpServletRequest servletRequest;
    private UAContext uaContext;
    private ContentDeliveryConfig deliveryConfig;
    private ContainerSession session;
    private ContainerContext containerContext;
    private Hashtable elementListTable = new Hashtable();
    private URI requestURI;

    public HttpServletContainerRequest(HttpServletRequest servletRequest, ServletConfig servletConfig, ServletContainerContext containerContext) throws UnknownDeviceException {
        if (servletRequest == null) {
            throw new IllegalArgumentException("null 'servletRequest' arg in constructor call.");
        }
        if (containerContext == null) {
            throw new IllegalArgumentException("null 'containerContext' arg in constructor call.");
        }
        this.servletRequest = servletRequest;
        this.containerContext = containerContext;
        this.uaContext = ServletUAContext.getInstance((HttpServletRequest)servletRequest, (ServletConfig)servletConfig);
        this.session = new HttpServletContainerSession(servletRequest.getSession());
        this.deliveryConfig = ContentDeliveryConfigImpl.getInstance((UAContext)this.uaContext, (ContainerContext)containerContext);
    }

    public String getContextPath() {
        return this.servletRequest.getContextPath();
    }

    public URI getRequestURI() {
        if (this.requestURI == null) {
            String queryString = this.servletRequest.getQueryString();
            this.requestURI = queryString != null ? URI.create(this.servletRequest.getRequestURL().toString() + "?" + queryString) : URI.create(this.servletRequest.getRequestURL().toString());
        }
        return this.requestURI;
    }

    public String getHeader(String name) {
        return this.servletRequest.getHeader(name);
    }

    public String getParameter(String name) {
        return this.servletRequest.getParameter(name);
    }

    public Enumeration getParameterNames() {
        return this.servletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.servletRequest.getParameterValues(name);
    }

    public ContainerContext getContext() {
        return this.containerContext;
    }

    public ContainerSession getSession() {
        return this.session;
    }

    public UAContext getUseragentContext() {
        return this.uaContext;
    }

    public ContentDeliveryConfig getDeliveryConfig() {
        return this.deliveryConfig;
    }

    public void setAttribute(String name, Object value) {
        this.servletRequest.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.servletRequest.removeAttribute(name);
    }

    public ElementList getElementList(String name) {
        String nameLower = name.toLowerCase();
        ElementList list = (ElementList)this.elementListTable.get(nameLower);
        if (list == null) {
            list = new ElementList();
            this.elementListTable.put(nameLower, list);
        }
        return list;
    }

    public void clearElementLists() {
        this.elementListTable.clear();
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }
}

