/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.container;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.container.ContainerContext;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.resource.ExternalResourceLocator;
import org.milyn.resource.ServletResourceLocator;
import org.milyn.resource.URIResourceLocator;

public class ServletContainerContext
implements ContainerContext {
    private ServletResourceLocator resourceLocator;
    private ServletContext servletContext;
    private SmooksResourceConfigurationStore resStore;

    public ServletContainerContext(ServletContext servletContext, ServletConfig servletConfig) {
        if (servletContext == null) {
            throw new IllegalArgumentException("null 'servletContext' arg in constructor call.");
        }
        if (servletConfig == null) {
            throw new IllegalArgumentException("null 'servletConfig' arg in constructor call.");
        }
        this.servletContext = servletContext;
        this.resourceLocator = new ServletResourceLocator(servletConfig, (ExternalResourceLocator)new URIResourceLocator());
        this.resStore = new SmooksResourceConfigurationStore((ContainerContext)this);
    }

    public ContainerResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public void setAttribute(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.servletContext.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.servletContext.removeAttribute(name);
    }

    public SmooksResourceConfigurationStore getStore() {
        return this.resStore;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

