/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.delivery;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.milyn.SmooksException;
import org.milyn.container.ContainerRequest;
import org.milyn.delivery.SmooksXML;
import org.milyn.logging.SmooksLogger;
import org.milyn.servlet.delivery.ServletResponseWrapper;
import org.milyn.servlet.http.HeaderAction;
import org.milyn.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLServletResponseWrapper
extends ServletResponseWrapper {
    private Log logger = SmooksLogger.getLog();
    private SmooksServletOutputStream stream;
    private PrintWriter printWriter;
    private SmooksXML smooks;
    private CharArrayWriter charArrayWriter = new CharArrayWriter();
    private List addHeaderActions = new Vector();
    private List removeHeaderActions = new Vector();
    public static final String SOURCE_DOCUMENT = (class$org$milyn$servlet$delivery$XMLServletResponseWrapper == null ? (class$org$milyn$servlet$delivery$XMLServletResponseWrapper = XMLServletResponseWrapper.class$("org.milyn.servlet.delivery.XMLServletResponseWrapper")) : class$org$milyn$servlet$delivery$XMLServletResponseWrapper).toString();
    static /* synthetic */ Class class$org$milyn$servlet$delivery$XMLServletResponseWrapper;
    static /* synthetic */ Class class$org$milyn$servlet$parse$HTMLSAXParser;

    public XMLServletResponseWrapper(ContainerRequest containerRequest, HttpServletResponse originalResponse) {
        super(containerRequest, originalResponse);
        this.smooks = new SmooksXML(containerRequest);
        this.initHeaderActions(containerRequest.getDeliveryConfig().getObjects("http-response-header"));
    }

    private void initHeaderActions(List headerActions) {
        if (headerActions == null) {
            return;
        }
        for (int i = 0; i < headerActions.size(); ++i) {
            HeaderAction action = (HeaderAction)((Object)headerActions.get(i));
            if (action.getAction() == 0) {
                this.addHeaderActions.add(action);
                continue;
            }
            this.removeHeaderActions.add(action);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("Call to 'getOutputStream()' after call to 'getWriter()'.");
        }
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = new SmooksServletOutputStream(this, this.charArrayWriter);
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException("Call to 'getWriter()' after call to 'getOutputStream()'.");
        }
        if (this.printWriter != null) {
            return this.printWriter;
        }
        this.printWriter = new SmooksPrintWriter(this.charArrayWriter, this);
        return this.printWriter;
    }

    public void addHeader(String name, String value) {
        if (this.assertAddHeader(name)) {
            super.addHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.assertAddHeader(name)) {
            super.setDateHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (this.assertAddHeader(name)) {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.assertAddHeader(name)) {
            super.setIntHeader(name, value);
        }
    }

    private boolean assertAddHeader(String name) {
        int removeCount = this.removeHeaderActions.size();
        for (int i = 0; i < removeCount; ++i) {
            if (!this.removeHeaderActions.get(i).equals(name)) continue;
            return false;
        }
        return true;
    }

    public void deliverResponse() throws IOException {
        HtmlByteArrayOutputStream outStream = new HtmlByteArrayOutputStream(10240);
        this.modifyResponseHeaders();
        ServletOutputStream targetOutputStream = this.getResponse().getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, this.getCharacterEncoding());
        char[] content = this.charArrayWriter.toCharArray();
        try {
            Node deliveryNode;
            Document sourceDoc = (Document)this.getContainerRequest().getAttribute(SOURCE_DOCUMENT);
            if (sourceDoc == null) {
                CharArrayReader inputReader = new CharArrayReader(content);
                Parser parser = new Parser(this.getContainerRequest(), (class$org$milyn$servlet$parse$HTMLSAXParser == null ? (class$org$milyn$servlet$parse$HTMLSAXParser = XMLServletResponseWrapper.class$("org.milyn.servlet.parse.HTMLSAXParser")) : class$org$milyn$servlet$parse$HTMLSAXParser).getName());
                try {
                    sourceDoc = parser.parse((Reader)inputReader);
                }
                catch (SAXException e) {
                    throw new SmooksException("Unable to filter InputStream for target useragent [" + this.getContainerRequest().getUseragentContext().getCommonName() + "].", (Throwable)e);
                }
                this.logger.info((Object)"Filtering content stream from down-stream Servlet/Filter.");
                deliveryNode = this.smooks.filter(sourceDoc);
            } else {
                this.logger.info((Object)"Filtering W3C DOM from down-stream Servlet/Filter.");
                deliveryNode = this.smooks.filter(sourceDoc);
            }
            this.smooks.serialize(deliveryNode, (Writer)writer);
            writer.flush();
            super.setIntHeader("Content-Length", outStream.size());
            outStream.writeToTarget((OutputStream)targetOutputStream);
        }
        catch (SmooksException e) {
            IOException ioE = new IOException("Unable to deliver response.");
            PrintWriter printWriter = new PrintWriter(writer);
            String contentString = new String(content);
            ioE.initCause(e);
            printWriter.println("<pre>");
            ioE.printStackTrace(printWriter);
            printWriter.println("</pre>");
            printWriter.println("<hr/>");
            printWriter.println("<pre>");
            contentString = contentString.replaceAll("<", "&lt;");
            contentString = contentString.replaceAll(">", "&gt;");
            printWriter.write(contentString);
            printWriter.println("</pre>");
            throw ioE;
        }
        finally {
            targetOutputStream.flush();
        }
    }

    private void modifyResponseHeaders() {
        ServletResponse response = this.getResponse();
        for (int i = 0; i < this.addHeaderActions.size(); ++i) {
            HeaderAction action = (HeaderAction)((Object)this.addHeaderActions.get(i));
            if (action.getHeaderName().equals("Content-Type")) {
                response.setContentType(action.getHeaderValue());
                continue;
            }
            if (action.getHeaderName().equals("Content-Length")) {
                try {
                    response.setContentLength(Integer.parseInt(action.getHeaderValue()));
                }
                catch (NumberFormatException fe) {}
                continue;
            }
            super.setHeader(action.getHeaderName(), action.getHeaderValue());
        }
    }

    public void close() {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Response wrapper stream close error.", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HtmlByteArrayOutputStream
    extends ByteArrayOutputStream {
        public HtmlByteArrayOutputStream(int size) {
            super(size);
        }

        private void writeToTarget(OutputStream outStream) throws IOException {
            outStream.write(this.buf, 0, this.count);
        }
    }

    class SmooksPrintWriter
    extends PrintWriter {
        CharArrayWriter charArrayWriter;
        ServletResponseWrapper responseWrapper;

        private SmooksPrintWriter(CharArrayWriter charArrayWriter, ServletResponseWrapper responseWrapper) throws IOException {
            super(charArrayWriter);
            this.charArrayWriter = charArrayWriter;
            this.responseWrapper = responseWrapper;
        }

        public void close() {
            super.close();
            this.charArrayWriter.close();
        }
    }

    class SmooksServletOutputStream
    extends ServletOutputStream {
        CharArrayWriter charArrayWriter;
        PrintWriter printWriter;
        ServletResponseWrapper responseWrapper;
        String charSet;

        private SmooksServletOutputStream(XMLServletResponseWrapper responseWrapper, CharArrayWriter charArrayWriter) {
            this.responseWrapper = responseWrapper;
            this.charArrayWriter = charArrayWriter;
            this.printWriter = new PrintWriter(charArrayWriter);
            this.charSet = responseWrapper.getCharacterEncoding();
        }

        public void close() throws IOException {
            this.charArrayWriter.close();
            this.printWriter.close();
            super.close();
        }

        public void write(int b) throws IOException {
            this.printWriter.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.printWriter.write(new String(b, off, len, this.charSet));
        }

        public void write(byte[] b) throws IOException {
            this.printWriter.write(new String(b, this.charSet));
        }

        public void print(boolean arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(char arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(double arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(float arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(int arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(long arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(String arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void println() throws IOException {
            this.printWriter.println();
        }

        public void println(boolean arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(char arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(double arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(float arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(int arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(long arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(String arg0) throws IOException {
            this.printWriter.println(arg0);
        }
    }
}

