/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.classification;

import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.mleap.classification.SVMBase;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.BLAS$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4Aa\u0004\t\u0001;!Aa\u0006\u0001BC\u0002\u0013\u0005s\u0006\u0003\u0005>\u0001\t\u0005\t\u0015!\u00031\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b\u001d\u0003A\u0011A&\t\u000b5\u0003A\u0011\u0001(\t\u000bY\u0003A\u0011A,\t\u000ba\u0003A\u0011A-\t\u000bq\u0003A\u0011I/\t\u000b}\u0003A\u0011\u000b1\t\u000b\t\u0004A\u0011I2\t\u000b\u001d\u0004A\u0011\t5\t\u000bE\u0004A\u0011\u000b:\u0003\u0011M3V*T8eK2T!!\u0005\n\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u00111\u0003F\u0001\u0006[2,\u0017\r\u001d\u0006\u0003+Y\t!!\u001c7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=-\u0002BaH\u0011$S5\t\u0001E\u0003\u0002\u0012)%\u0011!\u0005\t\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002%O5\tQE\u0003\u0002')\u00051A.\u001b8bY\u001eL!\u0001K\u0013\u0003\rY+7\r^8s!\tQ\u0003!D\u0001\u0011!\tQC&\u0003\u0002.!\t91KV'CCN,\u0017aA;jIV\t\u0001\u0007\u0005\u00022u9\u0011!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kq\ta\u0001\u0010:p_Rt$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2\u0014A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u001c\u0002\tULG\rI\u0001\u0006[>$W\r\\\u000b\u0002\u0001B\u0011\u0011)R\u0007\u0002\u0005*\u0011\u0011c\u0011\u0006\u0003\tZ\tQ!\u001c7mS\nL!a\u0004\"\u0002\r5|G-\u001a7!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011&\u0013&\t\u000b9*\u0001\u0019\u0001\u0019\t\u000by*\u0001\u0019\u0001!\u0015\u0005%b\u0005\"\u0002 \u0007\u0001\u0004\u0001\u0015\u0001D:fiRC'/Z:i_2$GCA(Q\u001b\u0005\u0001\u0001\"B)\b\u0001\u0004\u0011\u0016!\u0002<bYV,\u0007CA*U\u001b\u00051\u0014BA+7\u0005\u0019!u.\u001e2mK\u0006q1\r\\3beRC'/Z:i_2$G#A(\u0002\r5\f'oZ5o)\t\u0011&\fC\u0003\\\u0013\u0001\u00071%\u0001\u0005gK\u0006$XO]3t\u0003\u001d\u0001(/\u001a3jGR$\"A\u00150\t\u000bmS\u0001\u0019A\u0012\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000f\u0006\u0002$C\")1l\u0003a\u0001G\u0005Qa.^7DY\u0006\u001c8/Z:\u0016\u0003\u0011\u0004\"aU3\n\u0005\u00194$aA%oi\u0006!1m\u001c9z)\tI\u0013\u000eC\u0003k\u001b\u0001\u00071.A\u0003fqR\u0014\u0018\r\u0005\u0002m_6\tQN\u0003\u0002o)\u0005)\u0001/\u0019:b[&\u0011\u0001/\u001c\u0002\t!\u0006\u0014\u0018-\\'ba\u00061\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\r\u0006\u0002$g\")AO\u0004a\u0001G\u0005i!/Y<Qe\u0016$\u0017n\u0019;j_:\u0004")
public class SVMModel
extends ProbabilisticClassificationModel<Vector, SVMModel>
implements SVMBase {
    private final String uid;
    private final org.apache.spark.mllib.classification.SVMModel model;
    private final DoubleParam stepSize;
    private final IntParam numIterations;
    private final DoubleParam regParam;
    private final DoubleParam miniBatchFraction;
    private final BooleanParam fitIntercept;
    private final DoubleParam threshold;

    @Override
    public final double getStepSize() {
        return SVMBase.getStepSize$(this);
    }

    @Override
    public final int getNumIterations() {
        return SVMBase.getNumIterations$(this);
    }

    @Override
    public final double getRegParam() {
        return SVMBase.getRegParam$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return SVMBase.getMiniBatchFraction$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return SVMBase.getFitIntercept$(this);
    }

    @Override
    public final double getThreshold() {
        return SVMBase.getThreshold$(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final IntParam numIterations() {
        return this.numIterations;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$numIterations_$eq(IntParam x$1) {
        this.numIterations = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.classification.SVMModel model() {
        return this.model;
    }

    public SVMModel setThreshold(double value) {
        this.model().setThreshold(value);
        return (SVMModel)this.set((Param)this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVMModel clearThreshold() {
        return (SVMModel)this.clear((Param)this.threshold());
    }

    public double margin(Vector features) {
        return BLAS$.MODULE$.dot(this.model().weights(), org.apache.spark.mllib.linalg.Vectors$.MODULE$.dense(features.toArray())) + this.model().intercept();
    }

    public double predict(Vector features) {
        return this.margin(features) > this.getThreshold() ? 1.0 : 0.0;
    }

    public Vector predictRaw(Vector features) {
        double m = this.margin(features);
        return Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    public int numClasses() {
        return 2;
    }

    public SVMModel copy(ParamMap extra) {
        return (SVMModel)this.copyValues(new SVMModel(this.uid(), this.model()), extra);
    }

    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        return rawPrediction;
    }

    public SVMModel(String uid, org.apache.spark.mllib.classification.SVMModel model) {
        this.uid = uid;
        this.model = model;
        SVMBase.$init$(this);
        model.getThreshold().foreach((Function1 & java.io.Serializable & Serializable)t -> this.setThreshold(BoxesRunTime.unboxToDouble((Object)t)));
    }

    public SVMModel(org.apache.spark.mllib.classification.SVMModel model) {
        this(Identifiable$.MODULE$.randomUID("svmModel"), model);
    }
}

