/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bundle.ops.classification;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import ml.combust.bundle.BundleContext;
import ml.combust.bundle.dsl.Bundle;
import ml.combust.bundle.dsl.HasAttributes;
import ml.combust.bundle.dsl.Model;
import ml.combust.bundle.dsl.NodeShape;
import ml.combust.bundle.dsl.Value$;
import ml.combust.bundle.op.OpModel;
import ml.combust.mleap.tensor.DenseTensor;
import ml.combust.mleap.tensor.Tensor;
import org.apache.spark.ml.bundle.ParamSpec;
import org.apache.spark.ml.bundle.ParamSpec$;
import org.apache.spark.ml.bundle.SimpleParamSpec;
import org.apache.spark.ml.bundle.SimpleSparkOp;
import org.apache.spark.ml.bundle.SparkBundleContext;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u001d4Aa\u0002\u0005\u0001/!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00032\u0003B\u0002\u001b\u0001A\u0003%q\u0005C\u00036\u0001\u0011\u0005c\u0007C\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003a\u0001\u0011\u0005\u0013M\u0001\u000bM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tw\n\u001d\u0006\u0003\u0013)\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\f\u0019\u0005\u0019q\u000e]:\u000b\u00055q\u0011A\u00022v]\u0012dWM\u0003\u0002\u0010!\u0005\u0011Q\u000e\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\rI\"\u0004H\u0007\u0002\u0019%\u00111\u0004\u0004\u0002\u000e'&l\u0007\u000f\\3Ta\u0006\u00148n\u00149\u0011\u0005uyR\"\u0001\u0010\u000b\u0005%q\u0011B\u0001\u0011\u001f\u0005]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G.\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u0011\u0005)Qj\u001c3fYV\tq\u0005\u0005\u0003)_EbR\"A\u0015\u000b\u0005)Z\u0013AA8q\u0015\tiAF\u0003\u0002.]\u000591m\\7ckN$(\"A\b\n\u0005AJ#aB(q\u001b>$W\r\u001c\t\u00033IJ!a\r\u0007\u0003%M\u0003\u0018M]6Ck:$G.Z\"p]R,\u0007\u0010^\u0001\u0007\u001b>$W\r\u001c\u0011\u0002\u0013M\u0004\u0018M]6M_\u0006$G\u0003\u0002\u000f8\r:CQ\u0001\u000f\u0003A\u0002e\n1!^5e!\tQ4I\u0004\u0002<\u0003B\u0011AhP\u0007\u0002{)\u0011aHF\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~BQa\u0012\u0003A\u0002!\u000bQa\u001d5ba\u0016\u0004\"!\u0013'\u000e\u0003)S!aS\u0016\u0002\u0007\u0011\u001cH.\u0003\u0002N\u0015\nIaj\u001c3f'\"\f\u0007/\u001a\u0005\u0006\u001f\u0012\u0001\r\u0001H\u0001\u0006[>$W\r\\\u0001\fgB\f'o[%oaV$8\u000f\u0006\u0002S=B\u00191\u000bW.\u000f\u0005Q3fB\u0001\u001fV\u0013\u0005\u0001\u0015BA,@\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0007M+\u0017O\u0003\u0002X\u007fA\u0011\u0011\u0004X\u0005\u0003;2\u0011\u0011\u0002U1sC6\u001c\u0006/Z2\t\u000b}+\u0001\u0019\u0001\u000f\u0002\u0007=\u0014'.\u0001\u0007ta\u0006\u00148nT;uaV$8\u000f\u0006\u0002cMB\u00191\u000bW2\u0011\u0005e!\u0017BA3\r\u0005=\u0019\u0016.\u001c9mKB\u000b'/Y7Ta\u0016\u001c\u0007\"B0\u0007\u0001\u0004a\u0002")
public class LogisticRegressionOp
extends SimpleSparkOp<LogisticRegressionModel> {
    private final OpModel<SparkBundleContext, LogisticRegressionModel> Model = new OpModel<SparkBundleContext, LogisticRegressionModel>(null){
        private final Class<LogisticRegressionModel> klazz;

        public String modelOpName(Object obj, BundleContext context) {
            return OpModel.modelOpName$((OpModel)this, (Object)obj, (BundleContext)context);
        }

        public Class<LogisticRegressionModel> klazz() {
            return this.klazz;
        }

        public String opName() {
            return Bundle.BuiltinOps$.classification$.MODULE$.logistic_regression();
        }

        public Model store(Model model, LogisticRegressionModel obj, BundleContext<SparkBundleContext> context) {
            Model model2;
            Model m = (Model)model.withValue("num_classes", Value$.MODULE$.long((long)obj.numClasses()));
            if (obj.numClasses() > 2) {
                Matrix cm = obj.coefficientMatrix();
                None$ thresholds = obj.isSet((Param)obj.thresholds()) ? new Some((Object)obj.getThresholds()) : None$.MODULE$;
                model2 = (Model)((HasAttributes)((HasAttributes)m.withValue("coefficient_matrix", Value$.MODULE$.tensor((Tensor)new DenseTensor((Object)cm.toArray(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{cm.numRows(), cm.numCols()})), ClassTag$.MODULE$.Double())))).withValue("intercept_vector", Value$.MODULE$.vector((Object)obj.interceptVector().toArray(), ClassTag$.MODULE$.Double()))).withValue("thresholds", thresholds.map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$1)).toSeq()).map((Function1 & Serializable & scala.Serializable)value -> Value$.MODULE$.doubleList(value)));
            } else {
                model2 = (Model)((HasAttributes)((HasAttributes)m.withValue("coefficients", Value$.MODULE$.vector((Object)obj.coefficients().toArray(), ClassTag$.MODULE$.Double()))).withValue("intercept", Value$.MODULE$.double(obj.intercept()))).withValue("threshold", Value$.MODULE$.double(obj.getThreshold()));
            }
            return model2;
        }

        public LogisticRegressionModel load(Model model, BundleContext<SparkBundleContext> context) {
            LogisticRegressionModel logisticRegressionModel;
            long numClasses = model.value("num_classes").getLong();
            if (numClasses > 2L) {
                Tensor cmTensor = model.value("coefficient_matrix").getTensor();
                Matrix coefficientMatrix = Matrices$.MODULE$.dense(BoxesRunTime.unboxToInt((Object)cmTensor.dimensions().head()), BoxesRunTime.unboxToInt((Object)cmTensor.dimensions().apply(1)), (double[])cmTensor.toArray());
                LogisticRegressionModel lr = new LogisticRegressionModel("", coefficientMatrix, Vectors$.MODULE$.dense((double[])model.value("intercept_vector").getTensor().toArray()), (int)numClasses, true);
                logisticRegressionModel = (LogisticRegressionModel)model.getValue("thresholds").map((Function1 & Serializable & scala.Serializable)t -> lr.setThresholds((double[])t.getDoubleList().toArray(ClassTag$.MODULE$.Double()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> lr);
            } else {
                LogisticRegressionModel lr = new LogisticRegressionModel("", Vectors$.MODULE$.dense((double[])model.value("coefficients").getTensor().toArray()), model.value("intercept").getDouble());
                logisticRegressionModel = (LogisticRegressionModel)model.getValue("threshold").map((Function1 & Serializable & scala.Serializable)t -> lr.setThreshold(t.getDouble())).getOrElse((Function0 & Serializable & scala.Serializable)() -> lr);
            }
            LogisticRegressionModel r = logisticRegressionModel;
            return r;
        }
        {
            OpModel.$init$((OpModel)this);
            this.klazz = LogisticRegressionModel.class;
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$store$1(double[] ), $anonfun$store$2(scala.collection.Seq ), $anonfun$load$1(org.apache.spark.ml.classification.LogisticRegressionModel ml.combust.bundle.dsl.Value ), $anonfun$load$2(org.apache.spark.ml.classification.LogisticRegressionModel ), $anonfun$load$3(org.apache.spark.ml.classification.LogisticRegressionModel ml.combust.bundle.dsl.Value ), $anonfun$load$4(org.apache.spark.ml.classification.LogisticRegressionModel )}, serializedLambda);
        }
    };

    public OpModel<SparkBundleContext, LogisticRegressionModel> Model() {
        return this.Model;
    }

    public LogisticRegressionModel sparkLoad(String uid, NodeShape shape, LogisticRegressionModel model) {
        LogisticRegressionModel logisticRegressionModel;
        int numClasses = model.numClasses();
        if (numClasses > 2) {
            LogisticRegressionModel lr = new LogisticRegressionModel(uid, model.coefficientMatrix(), model.interceptVector(), numClasses, true);
            Object object = model.isDefined((Param)model.thresholds()) ? lr.setThresholds(model.getThresholds()) : BoxedUnit.UNIT;
            logisticRegressionModel = lr;
        } else {
            LogisticRegressionModel lr = new LogisticRegressionModel(uid, model.coefficientMatrix(), model.interceptVector(), numClasses, false);
            Object object = model.isDefined((Param)model.threshold()) ? lr.setThreshold(model.getThreshold()) : BoxedUnit.UNIT;
            logisticRegressionModel = lr;
        }
        LogisticRegressionModel r = logisticRegressionModel;
        return r;
    }

    public Seq<ParamSpec> sparkInputs(LogisticRegressionModel obj) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleParamSpec[]{ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)obj.featuresCol()))}));
    }

    public Seq<SimpleParamSpec> sparkOutputs(LogisticRegressionModel obj) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleParamSpec[]{ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"raw_prediction"), (Object)obj.rawPredictionCol())), ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"probability"), (Object)obj.probabilityCol())), ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prediction"), (Object)obj.predictionCol()))}));
    }

    public LogisticRegressionOp() {
        super(ClassTag$.MODULE$.apply(LogisticRegressionModel.class));
    }
}

