/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.scala.spark;

import java.io.Serializable;
import ml.dmlc.xgboost4j.scala.EvalTrait;
import ml.dmlc.xgboost4j.scala.ExternalCheckpointParams;
import ml.dmlc.xgboost4j.scala.ExternalCheckpointParams$;
import ml.dmlc.xgboost4j.scala.ObjectiveTrait;
import ml.dmlc.xgboost4j.scala.spark.TrackerConf;
import ml.dmlc.xgboost4j.scala.spark.TrackerConf$;
import ml.dmlc.xgboost4j.scala.spark.XGBoostExecutionInputParams;
import ml.dmlc.xgboost4j.scala.spark.XGBoostExecutionParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00114a!\u0004\b!\u0002\u0013I\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011E\u0002!\u0011!Q\u0001\nIBQa\u000f\u0001\u0005\u0002qBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\t\u0006\u0001)A\u0005\u001d\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002+\u0001A\u0003%\u0001\u0005C\u0003V\u0001\u0011%a\u000bC\u0003[\u0001\u0011%1\fC\u0003`\u0001\u0011\u0005\u0001MA\u000fY\u000f\n{wn\u001d;Fq\u0016\u001cW\u000f^5p]B\u000b'/Y7t\r\u0006\u001cGo\u001c:z\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u0005)1oY1mC*\u00111\u0003F\u0001\nq\u001e\u0014wn\\:ui)T!!\u0006\f\u0002\t\u0011lGn\u0019\u0006\u0002/\u0005\u0011Q\u000e\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c;5\tADC\u0001\u0012\u0013\tqBD\u0001\u0004B]f\u0014VMZ\u0001\ne\u0006<\b+\u0019:b[N\u0004B!\t\u0015,]9\u0011!E\n\t\u0003Gqi\u0011\u0001\n\u0006\u0003Ka\ta\u0001\u0010:p_Rt\u0014BA\u0014\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0004\u001b\u0006\u0004(BA\u0014\u001d!\t\tC&\u0003\u0002.U\t11\u000b\u001e:j]\u001e\u0004\"aG\u0018\n\u0005Ab\"aA!os\u0006\u00111o\u0019\t\u0003gej\u0011\u0001\u000e\u0006\u0003\u001fUR!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO&\u0011!\b\u000e\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007uz\u0004\t\u0005\u0002?\u00015\ta\u0002C\u0003 \u0007\u0001\u0007\u0001\u0005C\u00032\u0007\u0001\u0007!'\u0001\u0004m_\u001e<WM]\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\bY><w-\u001b8h\u0015\tAU'A\u0004d_6lwN\\:\n\u0005)+%a\u0001'pO\u00069An\\4hKJ\u0004\u0013aB5t\u0019>\u001c\u0017\r\\\u000b\u0002\u001dB\u00111dT\u0005\u0003!r\u0011qAQ8pY\u0016\fg.\u0001\u0005jg2{7-\u00197!\u0003=yg/\u001a:sS\u0012,G\rU1sC6\u001cX#\u0001\u0011\u0002!=4XM\u001d:jI\u0016$\u0007+\u0019:b[N\u0004\u0013\u0001\u0006<bY&$\u0017\r^3Ta\u0006\u00148nU:m\u0007>tg\rF\u0001X!\tY\u0002,\u0003\u0002Z9\t!QK\\5u\u00039yg/\u001a:sS\u0012,\u0007+\u0019:b[N$2\u0001\t/_\u0011\u0015i6\u00021\u0001!\u0003\u0019\u0001\u0018M]1ng\")\u0011g\u0003a\u0001e\u0005)\"-^5mIb;%IU;oi&lW\rU1sC6\u001cX#A1\u0011\u0005y\u0012\u0017BA2\u000f\u0005YAvIQ8pgR,\u00050Z2vi&|g\u000eU1sC6\u001c\b")
public class XGBoostExecutionParamsFactory {
    private final SparkContext sc;
    private final Log logger;
    private final boolean isLocal;
    private final Map<String, Object> overridedParams;

    private Log logger() {
        return this.logger;
    }

    private boolean isLocal() {
        return this.isLocal;
    }

    private Map<String, Object> overridedParams() {
        return this.overridedParams;
    }

    private void validateSparkSslConf() {
        Tuple2.mcZZ.sp sp2;
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession ss = (SparkSession)some.value();
            sp2 = new Tuple2.mcZZ.sp(new StringOps(Predef$.MODULE$.augmentString((String)ss.conf().getOption("spark.ssl.enabled").getOrElse((Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString((String)ss.conf().getOption("xgboost.spark.ignoreSsl").getOrElse((Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean());
        } else if (None$.MODULE$.equals(option)) {
            sp2 = new Tuple2.mcZZ.sp(this.sc.getConf().getBoolean("spark.ssl.enabled", false), this.sc.getConf().getBoolean("xgboost.spark.ignoreSsl", false));
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean sparkSslEnabled = sp3._1$mcZ$sp();
        boolean xgboostSparkIgnoreSsl = sp3._2$mcZ$sp();
        boolean bl = sparkSslEnabled;
        boolean bl2 = xgboostSparkIgnoreSsl;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl, bl2);
        boolean sparkSslEnabled2 = sp4._1$mcZ$sp();
        boolean xgboostSparkIgnoreSsl2 = sp4._2$mcZ$sp();
        if (sparkSslEnabled2) {
            if (xgboostSparkIgnoreSsl2) {
                this.logger().warn((Object)new StringBuilder(147).append("spark-xgboost is being run without encrypting data in transit!  ").append("Spark Conf spark.ssl.enabled=true was overridden with xgboost.spark.ignoreSsl=true.").toString());
                return;
            }
            throw new Exception("xgboost-spark found spark.ssl.enabled=true to encrypt data in transit, but xgboost-spark sends non-encrypted data over the wire for efficiency. To override this protection and still use xgboost-spark at your own risk, you can set the SparkSession conf to use xgboost.spark.ignoreSsl=true.");
        }
    }

    private Map<String, Object> overrideParams(Map<String, Object> params, SparkContext sc) {
        int coresPerTask = sc.getConf().getInt("spark.task.cpus", 1);
        Map overridedParams = params;
        if (overridedParams.contains((Object)"nthread")) {
            int nThread = new StringOps(Predef$.MODULE$.augmentString(overridedParams.apply((Object)"nthread").toString())).toInt();
            Predef$.MODULE$.require(nThread <= coresPerTask, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("the nthread configuration (").append(nThread).append(") must be no larger than ").append("spark.task.cpus (").append(coresPerTask).append(")").toString());
        } else {
            overridedParams = overridedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nthread"), (Object)BoxesRunTime.boxToInteger((int)coresPerTask)));
        }
        int numEarlyStoppingRounds = BoxesRunTime.unboxToInt((Object)overridedParams.getOrElse((Object)"num_early_stopping_rounds", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        overridedParams = overridedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num_early_stopping_rounds"), (Object)BoxesRunTime.boxToInteger((int)numEarlyStoppingRounds)));
        if (numEarlyStoppingRounds > 0 && overridedParams.getOrElse((Object)"custom_eval", (Function0 & Serializable & scala.Serializable)() -> null) != null) {
            throw new IllegalArgumentException("custom_eval does not support early stopping");
        }
        return overridedParams;
    }

    public XGBoostExecutionParams buildXGBRuntimeParams() {
        Some some;
        Object conf;
        TrackerConf trackerConf;
        ObjectiveTrait obj = (ObjectiveTrait)this.overridedParams().getOrElse((Object)"custom_obj", (Function0 & Serializable & scala.Serializable)() -> null);
        EvalTrait eval = (EvalTrait)this.overridedParams().getOrElse((Object)"custom_eval", (Function0 & Serializable & scala.Serializable)() -> null);
        if (obj != null) {
            Predef$.MODULE$.require(this.overridedParams().get((Object)"objective_type").isDefined(), (Function0 & Serializable & scala.Serializable)() -> "parameter \"objective_type\" is not defined, you have to specify the objective type as classification or regression with a customized objective function");
        }
        double trainTestRatio = 1.0;
        if (this.overridedParams().contains((Object)"train_test_ratio")) {
            this.logger().warn((Object)"train_test_ratio is deprecated since XGBoost 0.82, we recommend to explicitly pass a training and multiple evaluation datasets by passing 'eval_sets' and 'eval_set_names'");
            trainTestRatio = BoxesRunTime.unboxToDouble((Object)this.overridedParams().get((Object)"train_test_ratio").get());
        }
        int nWorkers = BoxesRunTime.unboxToInt((Object)this.overridedParams().apply((Object)"num_workers"));
        int round = BoxesRunTime.unboxToInt((Object)this.overridedParams().apply((Object)"num_round"));
        boolean useExternalMemory = BoxesRunTime.unboxToBoolean((Object)this.overridedParams().getOrElse((Object)"use_external_memory", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        float missing = BoxesRunTime.unboxToFloat((Object)this.overridedParams().getOrElse((Object)"missing", (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> Float.NaN));
        boolean allowNonZeroForMissing = BoxesRunTime.unboxToBoolean((Object)this.overridedParams().getOrElse((Object)"allow_non_zero_for_missing", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        Option treeMethod = this.overridedParams().get((Object)"tree_method").map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString());
        Option device = this.overridedParams().get((Object)"device").map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString());
        boolean deviceIsGpu = device.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)XGBoostExecutionParamsFactory.$anonfun$buildXGBRuntimeParams$9(x$4)));
        Predef$.MODULE$.require(!treeMethod.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)XGBoostExecutionParamsFactory.$anonfun$buildXGBRuntimeParams$10(x$5))) || !deviceIsGpu, (Function0 & Serializable & scala.Serializable)() -> "The tree method \"approx\" is not yet supported for Spark GPU cluster");
        boolean runOnGpu = treeMethod.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XGBoostExecutionParamsFactory.$anonfun$buildXGBRuntimeParams$12(x$6))) || deviceIsGpu;
        Option option = this.overridedParams().get((Object)"tracker_conf");
        if (None$.MODULE$.equals(option)) {
            trackerConf = TrackerConf$.MODULE$.apply();
        } else if (option instanceof Some && (conf = (some = (Some)option).value()) instanceof TrackerConf) {
            TrackerConf trackerConf2;
            trackerConf = trackerConf2 = (TrackerConf)conf;
        } else {
            throw new IllegalArgumentException("parameter \"tracker_conf\" must be an instance of TrackerConf.");
        }
        TrackerConf trackerConf3 = trackerConf;
        Option checkpointParam = ExternalCheckpointParams$.MODULE$.extractParams(this.overridedParams());
        long seed = BoxesRunTime.unboxToLong((Object)this.overridedParams().getOrElse((Object)"seed", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.nanoTime()));
        XGBoostExecutionInputParams inputParams = new XGBoostExecutionInputParams(trainTestRatio, seed);
        int earlyStoppingRounds = BoxesRunTime.unboxToInt((Object)this.overridedParams().getOrElse((Object)"num_early_stopping_rounds", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        boolean cacheTrainingSet = BoxesRunTime.unboxToBoolean((Object)this.overridedParams().getOrElse((Object)"cache_training_set", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        None$ featureNames = this.overridedParams().contains((Object)"feature_names") ? new Some((Object)((String[])this.overridedParams().apply((Object)"feature_names"))) : None$.MODULE$;
        None$ featureTypes = this.overridedParams().contains((Object)"feature_types") ? new Some((Object)((String[])this.overridedParams().apply((Object)"feature_types"))) : None$.MODULE$;
        XGBoostExecutionParams xgbExecParam = new XGBoostExecutionParams(nWorkers, round, useExternalMemory, obj, eval, missing, allowNonZeroForMissing, trackerConf3, (Option<ExternalCheckpointParams>)checkpointParam, inputParams, earlyStoppingRounds, cacheTrainingSet, (Option<String>)device, this.isLocal(), (Option<String[]>)featureNames, (Option<String[]>)featureTypes, runOnGpu);
        xgbExecParam.setRawParamMap(this.overridedParams());
        return xgbExecParam;
    }

    public static final /* synthetic */ boolean $anonfun$buildXGBRuntimeParams$9(String x$4) {
        String string = x$4;
        String string2 = "cuda";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildXGBRuntimeParams$10(String x$5) {
        String string = x$5;
        String string2 = "approx";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildXGBRuntimeParams$12(String x$6) {
        String string = x$6;
        String string2 = "gpu_hist";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public XGBoostExecutionParamsFactory(Map<String, Object> rawParams, SparkContext sc) {
        this.sc = sc;
        this.logger = LogFactory.getLog((String)"XGBoostSpark");
        this.isLocal = sc.isLocal();
        this.overridedParams = this.overrideParams(rawParams, sc);
        this.validateSparkSslConf();
    }
}

