/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;

public class ConfigContext
implements AutoCloseable {
    private final String initialConfiguration;

    public ConfigContext() throws XGBoostError {
        this.initialConfiguration = this.getGlobalConfig();
    }

    public ConfigContext(Map<String, Object> params) throws XGBoostError {
        if (params != null && !params.isEmpty()) {
            this.initialConfiguration = this.getGlobalConfig();
            this.setConfigs(params);
        } else {
            this.initialConfiguration = null;
        }
    }

    private String getGlobalConfig() throws XGBoostError {
        String[] config = new String[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGBGetGlobalConfig(config));
        return config[0];
    }

    public Object getConfig(String name) throws XGBoostError {
        String jconfig = this.getGlobalConfig();
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(jconfig, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map.get(name);
        }
        catch (JsonProcessingException ex) {
            throw new XGBoostError("Failed to get the global config due to a decode error.", ex);
        }
    }

    public void setConfig(String key, Object value) throws XGBoostError {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(key, value);
        ObjectMapper mapper = new ObjectMapper();
        try {
            String config = mapper.writeValueAsString(configs);
            XGBoostJNI.checkCall(XGBoostJNI.XGBSetGlobalConfig(config));
        }
        catch (JsonProcessingException ex) {
            throw new XGBoostError("Failed to set the global config due to an encode error.", ex);
        }
    }

    public void setConfigs(Map<String, Object> configs) throws XGBoostError {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String config = mapper.writeValueAsString(configs);
            XGBoostJNI.checkCall(XGBoostJNI.XGBSetGlobalConfig(config));
        }
        catch (JsonProcessingException ex) {
            throw new XGBoostError("Failed to set the global config due to an encode error.", ex);
        }
    }

    @Override
    public void close() throws XGBoostError {
        if (this.initialConfiguration != null) {
            XGBoostJNI.checkCall(XGBoostJNI.XGBSetGlobalConfig(this.initialConfiguration));
        }
    }
}

