/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import ml.dmlc.xgboost4j.java.ITracker;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabitTracker
implements ITracker {
    private static final Log logger = LogFactory.getLog(RabitTracker.class);
    private long handle = 0L;
    private Thread trackerDaemon;

    public RabitTracker(int numWorkers) throws XGBoostError {
        this(numWorkers, "");
    }

    public RabitTracker(int numWorkers, String hostIp) throws XGBoostError {
        this(numWorkers, hostIp, 0, 300);
    }

    public RabitTracker(int numWorkers, String hostIp, int port, int timeout) throws XGBoostError {
        if (numWorkers < 1) {
            throw new XGBoostError("numWorkers must be greater equal to one");
        }
        long[] out = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.TrackerCreate(hostIp, numWorkers, port, 0, timeout, out));
        this.handle = out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error((Object)"Uncaught exception thrown by worker:", e);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            logger.error((Object)ex);
        }
        finally {
            this.trackerDaemon.interrupt();
        }
    }

    @Override
    public Map<String, Object> getWorkerArgs() throws XGBoostError {
        Map config;
        String[] args = new String[1];
        XGBoostJNI.checkCall(XGBoostJNI.TrackerWorkerArgs(this.handle, 0L, args));
        ObjectMapper mapper = new ObjectMapper();
        try {
            config = (Map)mapper.readValue(args[0], (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new XGBoostError("Failed to get worker arguments.", ex);
        }
        return config;
    }

    @Override
    public void stop() throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.TrackerFree(this.handle));
    }

    @Override
    public boolean start() throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.TrackerRun(this.handle));
        this.trackerDaemon = new Thread(() -> {
            try {
                this.waitFor(0L);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                return;
            }
        });
        this.trackerDaemon.setDaemon(true);
        this.trackerDaemon.start();
        return this.trackerDaemon.isAlive();
    }

    @Override
    public void waitFor(long timeout) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.TrackerWaitFor(this.handle, timeout));
    }
}

