/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.xgboost;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.json4s.JsonAST;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

public final class SparkUtils$ {
    public static SparkUtils$ MODULE$;

    static {
        new SparkUtils$();
    }

    private Column checkClassificationLabels(String labelCol, Option<Object> numClasses) {
        Some some;
        int n;
        Column casted = functions$.MODULE$.col(labelCol).cast((DataType)DoubleType$.MODULE$);
        Option<Object> option = numClasses;
        if (option instanceof Some && 2 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()))) {
            return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be in {0, 1}, but got "), casted})))).otherwise((Object)casted);
        }
        int n2 = BoxesRunTime.unboxToInt((Object)numClasses.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        Predef$.MODULE$.require(0 < n2 && n2 <= Integer.MAX_VALUE);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$greater$eq((Object)BoxesRunTime.boxToInteger((int)n2))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)new StringBuilder(33).append("Labels MUST be in [0, ").append(n2).append("), but got ").toString()), casted})))).when(casted.$eq$bang$eq((Object)casted.cast((DataType)IntegerType$.MODULE$)), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be Integers, but got "), casted})))).otherwise((Object)casted);
    }

    public int getNumClasses(Dataset<?> dataset, String labelCol, int maxNumClasses) {
        Option option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(labelCol));
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            int n2 = n = BoxesRunTime.unboxToInt((Object)some.value());
            return n2;
        }
        if (None$.MODULE$.equals(option)) {
            Row[] maxLabelRow = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.checkClassificationLabels(labelCol, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxNumClasses))))})).take(1);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).isEmpty() || maxLabelRow[0].get(0) == null) {
                throw new SparkException("ML algorithm was given empty dataset.");
            }
            double maxDoubleLabel = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).head()).getDouble(0);
            Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Classifier found max label value =").append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString());
            int numClasses = (int)maxDoubleLabel + 1;
            Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(286).append("Classifier inferred ").append(numClasses).append(" from label values").append(" in column ").append(labelCol).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
            return numClasses;
        }
        throw new MatchError((Object)option);
    }

    public int getNumClasses$default$3() {
        return 100;
    }

    public void checkNumericType(StructType schema, String colName, String msg) {
        SchemaUtils$.MODULE$.checkNumericType(schema, colName, msg);
    }

    public String checkNumericType$default$3() {
        return "";
    }

    public void saveMetadata(Params instance, String path, SparkContext sc, Option<JsonAST.JObject> extraMetadata, Option<JsonAST.JValue> paramMap) {
        DefaultParamsWriter$.MODULE$.saveMetadata(instance, path, sc, extraMetadata, paramMap);
    }

    public Option<JsonAST.JObject> saveMetadata$default$4() {
        return None$.MODULE$;
    }

    public Option<JsonAST.JValue> saveMetadata$default$5() {
        return None$.MODULE$;
    }

    public DefaultParamsReader.Metadata loadMetadata(String path, SparkContext sc, String expectedClassName) {
        return DefaultParamsReader$.MODULE$.loadMetadata(path, sc, expectedClassName);
    }

    public String loadMetadata$default$3() {
        return "";
    }

    public StructType appendColumn(StructType schema, String colName, DataType dataType, boolean nullable) {
        return SchemaUtils$.MODULE$.appendColumn(schema, colName, dataType, nullable);
    }

    public boolean appendColumn$default$4() {
        return false;
    }

    public StructType appendVectorUDTColumn(StructType schema, String colName, DataType dataType, boolean nullable) {
        return SchemaUtils$.MODULE$.appendColumn(schema, colName, dataType, nullable);
    }

    public DataType appendVectorUDTColumn$default$3() {
        return new VectorUDT();
    }

    public boolean appendVectorUDTColumn$default$4() {
        return false;
    }

    public boolean isVectorType(DataType dataType) {
        return dataType instanceof VectorUDT;
    }

    private SparkUtils$() {
        MODULE$ = this;
    }
}

