/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            OS os = OS.detectOS();
            Arch arch = Arch.detectArch();
            for (String libName : libNames) {
                try {
                    String libraryPathInJar = LibraryPathProvider.getLibraryPathFor(os, arch, libName);
                    NativeLibLoader.loadLibraryFromJar(libraryPathInJar);
                }
                catch (UnsatisfiedLinkError ule) {
                    String failureMessageIncludingOpenMPHint = "Failed to load " + libName + " due to missing native dependencies for platform " + NativeLibLoader.getPlatformFor(os, arch) + ", this is likely due to a missing OpenMP dependency";
                    switch (os) {
                        case WINDOWS: {
                            logger.error((Object)failureMessageIncludingOpenMPHint);
                            logger.error((Object)"You may need to install 'vcomp140.dll' or 'libgomp-1.dll'");
                            break;
                        }
                        case MACOS: {
                            logger.error((Object)failureMessageIncludingOpenMPHint);
                            logger.error((Object)"You may need to install 'libomp.dylib', via `brew install libomp` or similar");
                            break;
                        }
                        case LINUX: {
                            logger.error((Object)failureMessageIncludingOpenMPHint);
                            logger.error((Object)"You may need to install 'libgomp.so' (or glibc) via your package manager.");
                            logger.error((Object)("Alternatively, if your Linux OS is musl-based, you should set the path for the native library " + libName + " via the system property " + LibraryPathProvider.getPropertyNameForLibrary(libName)));
                            break;
                        }
                        case SOLARIS: {
                            logger.error((Object)failureMessageIncludingOpenMPHint);
                            logger.error((Object)"You may need to install 'libgomp.so' (or glibc) via your package manager.");
                        }
                    }
                    throw ule;
                }
                catch (IOException ioe) {
                    logger.error((Object)("Failed to load " + libName + " library from jar for platform " + NativeLibLoader.getPlatformFor(os, arch)));
                    throw ioe;
                }
            }
            initialized = true;
        }
    }

    private static void loadLibraryFromJar(String path) throws IOException, IllegalArgumentException {
        String temp = NativeLibLoader.createTempFileFromResource(path);
        System.load(temp);
    }

    static String createTempFileFromResource(String path) throws IOException, IllegalArgumentException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        try (InputStream is = NativeLibLoader.class.getResourceAsStream(path);
             FileOutputStream os = new FileOutputStream(temp);){
            int readBytes;
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        return temp.getAbsolutePath();
    }

    private static String getPlatformFor(OS os, Arch arch) {
        return os.name + "/" + arch.name;
    }

    static class LibraryPathProvider {
        private static final String nativeResourcePath = "/lib";
        private static final String customNativeLibraryPathPropertyPrefix = "xgboostruntime.native.";

        LibraryPathProvider() {
        }

        static String getPropertyNameForLibrary(String libName) {
            return customNativeLibraryPathPropertyPrefix + libName;
        }

        static String getLibraryPathFor(OS os, Arch arch, String libName) {
            String libraryPath = System.getProperty(LibraryPathProvider.getPropertyNameForLibrary(libName));
            if (libraryPath == null) {
                libraryPath = "/lib/" + NativeLibLoader.getPlatformFor(os, arch) + "/" + System.mapLibraryName(libName);
            }
            logger.debug((Object)("Using path " + libraryPath + " for library with name " + libName));
            return libraryPath;
        }
    }

    static enum Arch {
        X86_64("x86_64"),
        AARCH64("aarch64"),
        SPARC("sparc");

        final String name;

        private Arch(String name) {
            this.name = name;
        }

        static Arch detectArch() {
            String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
            if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
                return X86_64;
            }
            if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
                return AARCH64;
            }
            if (arch.startsWith("sparc")) {
                return SPARC;
            }
            throw new IllegalStateException("Unsupported architecture:" + arch);
        }
    }

    static enum OS {
        WINDOWS("windows"),
        MACOS("macos"),
        LINUX("linux"),
        SOLARIS("solaris");

        final String name;

        private OS(String name) {
            this.name = name;
        }

        static OS detectOS() {
            String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if (os.contains("mac") || os.contains("darwin")) {
                return MACOS;
            }
            if (os.contains("win")) {
                return WINDOWS;
            }
            if (os.contains("nux")) {
                return LINUX;
            }
            if (os.contains("sunos")) {
                return SOLARIS;
            }
            throw new IllegalStateException("Unsupported OS:" + os);
        }
    }
}

