/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import mn.foreman.api.ForemanApi;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.actions.Actions;
import mn.foreman.api.endpoints.actions.ActionsImpl;
import mn.foreman.api.endpoints.autominer.Autominer;
import mn.foreman.api.endpoints.autominer.AutominerImpl;
import mn.foreman.api.endpoints.claymore.Claymore;
import mn.foreman.api.endpoints.claymore.ClaymoreImpl;
import mn.foreman.api.endpoints.csp.Csp;
import mn.foreman.api.endpoints.csp.CspImpl;
import mn.foreman.api.endpoints.groups.Groups;
import mn.foreman.api.endpoints.groups.GroupsImpl;
import mn.foreman.api.endpoints.miners.Miners;
import mn.foreman.api.endpoints.miners.MinersImpl;
import mn.foreman.api.endpoints.nicehash.Nicehash;
import mn.foreman.api.endpoints.nicehash.NicehashImpl;
import mn.foreman.api.endpoints.notifications.Notifications;
import mn.foreman.api.endpoints.notifications.NotificationsImpl;
import mn.foreman.api.endpoints.pickaxe.Pickaxe;
import mn.foreman.api.endpoints.pickaxe.PickaxeImpl;
import mn.foreman.api.endpoints.ping.Ping;
import mn.foreman.api.endpoints.ping.PingImpl;
import mn.foreman.api.endpoints.qse.Qse;
import mn.foreman.api.endpoints.qse.QseImpl;
import mn.foreman.api.endpoints.sitemap.SiteMap;
import mn.foreman.api.endpoints.sitemap.SiteMapImpl;
import mn.foreman.api.endpoints.tags.Tags;
import mn.foreman.api.endpoints.tags.TagsImpl;

public class ForemanApiImpl
implements ForemanApi {
    private final String clientId;
    private final ObjectMapper objectMapper;
    private final String pickaxeId;
    private final WebUtil webUtil;

    public ForemanApiImpl(String clientId, String pickaxeId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.clientId = clientId;
        this.pickaxeId = pickaxeId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public Actions actions() {
        return new ActionsImpl(this.objectMapper, this.webUtil);
    }

    @Override
    public Autominer autominer() {
        return new AutominerImpl(this.objectMapper, this.webUtil);
    }

    @Override
    public Claymore claymore() {
        return new ClaymoreImpl(this.objectMapper, this.webUtil);
    }

    @Override
    public Csp csp() {
        return new CspImpl(this.pickaxeId, this.objectMapper, this.webUtil);
    }

    @Override
    public Groups groups() {
        return new GroupsImpl(this.clientId, this.objectMapper, this.webUtil);
    }

    @Override
    public Miners miners() {
        return new MinersImpl(this.clientId, this.pickaxeId, this.objectMapper, this.webUtil);
    }

    @Override
    public Nicehash nicehash() {
        return new NicehashImpl(this.objectMapper, this.webUtil);
    }

    @Override
    public Notifications notifications() {
        return new NotificationsImpl(this.clientId, this.objectMapper, this.webUtil);
    }

    @Override
    public Pickaxe pickaxe() {
        return new PickaxeImpl(this.clientId, this.pickaxeId, this.objectMapper, this.webUtil);
    }

    @Override
    public Ping ping() {
        return new PingImpl(this.clientId, this.webUtil);
    }

    @Override
    public Qse qse() {
        return new QseImpl(this.pickaxeId, this.objectMapper, this.webUtil);
    }

    @Override
    public SiteMap siteMap() {
        return new SiteMapImpl(this.objectMapper, this.webUtil);
    }

    @Override
    public Tags tags() {
        return new TagsImpl(this.objectMapper, this.webUtil);
    }
}

