/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mn.foreman.api.model.CommandUpdate;

public class CommandUpdateBatch {
    @JsonProperty(value="commands")
    private final List<BatchedUpdate> commands;

    CommandUpdateBatch(List<BatchedUpdate> commands) {
        this.commands = commands;
    }

    public static CommandUpdateBatchBuilder builder() {
        return new CommandUpdateBatchBuilder();
    }

    public List<BatchedUpdate> getCommands() {
        return this.commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandUpdateBatch)) {
            return false;
        }
        CommandUpdateBatch other = (CommandUpdateBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BatchedUpdate> this$commands = this.getCommands();
        List<BatchedUpdate> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandUpdateBatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BatchedUpdate> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "CommandUpdateBatch(commands=" + this.getCommands() + ")";
    }

    public static class CommandUpdateBatchBuilder {
        private ArrayList<BatchedUpdate> commands;

        CommandUpdateBatchBuilder() {
        }

        public CommandUpdateBatchBuilder command(BatchedUpdate command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        public CommandUpdateBatchBuilder commands(Collection<? extends BatchedUpdate> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public CommandUpdateBatchBuilder clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return this;
        }

        public CommandUpdateBatch build() {
            List<BatchedUpdate> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<BatchedUpdate>(this.commands));
                }
            }
            return new CommandUpdateBatch(commands);
        }

        public String toString() {
            return "CommandUpdateBatch.CommandUpdateBatchBuilder(commands=" + this.commands + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Response {
        @JsonProperty(value="success")
        public int success;
    }

    public static class BatchedUpdate {
        @JsonProperty(value="commandId")
        private final String commandId;
        @JsonProperty(value="update")
        private final CommandUpdate update;

        BatchedUpdate(String commandId, CommandUpdate update) {
            this.commandId = commandId;
            this.update = update;
        }

        public static BatchedUpdateBuilder builder() {
            return new BatchedUpdateBuilder();
        }

        public String getCommandId() {
            return this.commandId;
        }

        public CommandUpdate getUpdate() {
            return this.update;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchedUpdate)) {
                return false;
            }
            BatchedUpdate other = (BatchedUpdate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$commandId = this.getCommandId();
            String other$commandId = other.getCommandId();
            if (this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId)) {
                return false;
            }
            CommandUpdate this$update = this.getUpdate();
            CommandUpdate other$update = other.getUpdate();
            return !(this$update == null ? other$update != null : !((Object)this$update).equals(other$update));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchedUpdate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commandId = this.getCommandId();
            result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
            CommandUpdate $update = this.getUpdate();
            result = result * 59 + ($update == null ? 43 : ((Object)$update).hashCode());
            return result;
        }

        public String toString() {
            return "CommandUpdateBatch.BatchedUpdate(commandId=" + this.getCommandId() + ", update=" + this.getUpdate() + ")";
        }

        public static class BatchedUpdateBuilder {
            private String commandId;
            private CommandUpdate update;

            BatchedUpdateBuilder() {
            }

            @JsonProperty(value="commandId")
            public BatchedUpdateBuilder commandId(String commandId) {
                this.commandId = commandId;
                return this;
            }

            @JsonProperty(value="update")
            public BatchedUpdateBuilder update(CommandUpdate update) {
                this.update = update;
                return this;
            }

            public BatchedUpdate build() {
                return new BatchedUpdate(this.commandId, this.update);
            }

            public String toString() {
                return "CommandUpdateBatch.BatchedUpdate.BatchedUpdateBuilder(commandId=" + this.commandId + ", update=" + this.update + ")";
            }
        }
    }
}

