/*
 * AppsPress CONFIDENTIAL
 * ______________
 *
 * Copyright ©2016-2019, AppsPress Platform B.V.
 * All Rights Reserved.
 *
 * Legal address: Van Boshuizenstraat 12-2, 1083 BA, Amsterdam, Nederland,
 * KvK nummer (Trade Register number): 64504522
 *
 * NOTICE: All information contained herein is, and remains
 * the property of AppsPress Platform B.V. and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to AppsPress Platform B.V.
 * and its suppliers and may be covered by patents, patents in process,
 * and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from AppsPress Platform B.V.
 */

package com.appspress.component.properties.manager

import com.appspress.component.properties.model.PropertyListModel
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.Job

/**
 * Manager for properties.
 */
interface IPropertiesManager {

  /**
   * Get property by [key].
   */
  fun getPropertyAsync(key: String): Deferred<String?>

  /**
   * Set property [value] by [key].
   */
  fun setPropertyAsync(key: String, value: String?): Job?

  /**
   * Get property list by [key].
   */
  fun getPropertyListAsync(key: String): Deferred<PropertyListModel?>

  /**
   * Set property [value] by [key].
   */
  fun appendPropertyListAsync(key: String, value: List<String>): Job?

  /**
   * Clears property by [key]
   */
  fun clearPropertyListAsync(key: String): Job?

  /**
   * Clears property by [key] and ids in [value]
   */
  fun clearPropertyListAsync(key: String, value: PropertyListModel): Job?

  /**
   * Clears property list by [key] but keeps last [recordsToKeep] records
   */
  fun clearPropertyListAsync(key: String, recordsToKeep: Int): Job?

}
