package com.appspress.component.properties.repository.storage

import com.appspress.component.properties.model.PropertyListModel
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.Job

/**
 * Internal storage
 */
interface IInternalStorage: IStorage{

  fun getListAsync(key: String): Deferred<PropertyListModel?>

  fun putListAsync(key: String, value: List<String>): Job?

  fun appendListAsync(key: String, value: List<String>): Job?

  fun clearListAsync(key: String): Job?

  fun clearListAsync(key: String, value: PropertyListModel): Job?

  fun clearListAsync(key: String, recordsToKeep: Int): Job?

}