/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.processor.logger;

import com.appspress.component.MessageProcessorsComponentScope;
import com.appspress.component.processor.logger.ISilentMessageProcessorLogger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@MessageProcessorsComponentScope
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/appspress/component/processor/logger/SilentMessageProcessorLogger;", "Lcom/appspress/component/processor/logger/ISilentMessageProcessorLogger;", "()V", "failedToExecuteRequestWithGivenRetryCount", "", "e", "Ljava/lang/Exception;", "url", "", "retryCountMax", "", "pushId", "logFailedToConvertIdToInteger", "it", "logPushIdIsNull", "logUrlIsNotFoundInDataPayload", "key", "messageProcessedSuccessfully", "push-message-processors-component_release"})
public final class SilentMessageProcessorLogger
implements ISilentMessageProcessorLogger {
    @Override
    public void logPushIdIsNull() {
        Timber.e((Throwable)new IllegalStateException("Push id is not set"), (String)"Push id is not set or null", (Object[])new Object[0]);
    }

    @Override
    public void logFailedToConvertIdToInteger(@NotNull Exception e, @Nullable String it) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Timber.e((Throwable)new IllegalStateException(e), (String)("Failed to conevert id from " + it + " to int"), (Object[])new Object[0]);
    }

    @Override
    public void logUrlIsNotFoundInDataPayload(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Timber.e((Throwable)new IllegalStateException("Url is not found in data payload by key " + key));
    }

    @Override
    public void failedToExecuteRequestWithGivenRetryCount(@NotNull Exception e, @NotNull String url, int retryCountMax, int pushId) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Timber.e((Throwable)new IllegalStateException(e), (String)("Failed to execute request with given retry count " + retryCountMax + ", with url " + url), (Object[])new Object[0]);
    }

    @Override
    public void messageProcessedSuccessfully(int pushId) {
        Timber.d((String)"Silent message processed successfully", (Object[])new Object[0]);
    }

    @Inject
    public SilentMessageProcessorLogger() {
    }
}

