/*
 * Decompiled with CFR 0.152.
 */
package com.appspress.component.push.network;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/appspress/component/push/network/GzipRequestInterceptor;", "Lokhttp3/Interceptor;", "()V", "forceContentLength", "Lokhttp3/RequestBody;", "requestBody", "gzip", "body", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "push-network-component_release"})
public final class GzipRequestInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            Response response = chain.proceed(originalRequest);
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(originalRequest)");
            return response;
        }
        Request.Builder builder = originalRequest.newBuilder().header("Content-Encoding", "gzip");
        String string = originalRequest.method();
        RequestBody requestBody = originalRequest.body();
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"originalRequest.body()!!");
        Request compressedRequest = builder.method(string, this.forceContentLength(this.gzip(requestBody))).build();
        Response response = chain.proceed(compressedRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(compressedRequest)");
        return response;
    }

    private final RequestBody forceContentLength(RequestBody requestBody) throws IOException {
        Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        return new RequestBody(requestBody, buffer){
            final /* synthetic */ RequestBody $requestBody;
            final /* synthetic */ Buffer $buffer;

            @Nullable
            public MediaType contentType() {
                return this.$requestBody.contentType();
            }

            public long contentLength() {
                return this.$buffer.size();
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                sink.write(this.$buffer.snapshot());
            }
            {
                this.$requestBody = $captured_local_variable$0;
                this.$buffer = $captured_local_variable$1;
            }
        };
    }

    private final RequestBody gzip(RequestBody body) {
        return new RequestBody(body){
            final /* synthetic */ RequestBody $body;

            @Nullable
            public MediaType contentType() {
                return this.$body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                BufferedSink gzipSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)sink)));
                this.$body.writeTo(gzipSink);
                gzipSink.close();
            }
            {
                this.$body = $captured_local_variable$0;
            }
        };
    }
}

