/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.mobads.sdk.api.EntryResponse;
import com.baidu.mobads.sdk.api.ExpressResponse;
import com.baidu.mobads.sdk.api.NativeResponse;
import com.baidu.mobads.sdk.api.RequestParameters;
import com.baidu.mobads.sdk.internal.ac;
import com.baidu.mobads.sdk.internal.aj;
import com.baidu.mobads.sdk.internal.dd;
import com.baidu.mobads.sdk.internal.f;
import java.util.List;

public class BaiduNativeManager {
    private static final String TAG = BaiduNativeManager.class.getSimpleName();
    private static final int FEED_TIMEOUT = 8000;
    private final Context mContext;
    private final String mAdPlacementId;
    private boolean isCacheVideo = true;
    private int mTimeoutMillis = 8000;
    private boolean isCacheVideoOnlyWifi = false;
    private String mAppSid;
    private RequestParameters mRequestParameters;
    private int mBidFloor = -1;

    public BaiduNativeManager(Context context, String string) {
        this(context, string, 8000);
    }

    public BaiduNativeManager(Context context, String string, int n2) {
        this(context, string, true, n2);
    }

    public BaiduNativeManager(Context context, String string, boolean bl2) {
        this(context, string, bl2, 8000);
    }

    public BaiduNativeManager(Context context, String string, boolean bl2, int n2) {
        this.mContext = context;
        this.mAdPlacementId = string;
        this.isCacheVideo = bl2;
        this.mTimeoutMillis = n2;
    }

    public void setCacheVideoOnlyWifi(boolean bl2) {
        this.isCacheVideoOnlyWifi = bl2;
    }

    public void loadFeedAd(RequestParameters requestParameters, FeedAdListener feedAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), new ac(feedAdListener), this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.b(requestParameters);
    }

    public void loadContentAd(RequestParameters requestParameters, FeedAdListener feedAdListener) {
        f f2 = new f(this.mContext, new ac(feedAdListener), new dd(this.mContext, this.getAdPlacemenId(requestParameters), "content", this.isCacheVideo, this.mTimeoutMillis));
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.b(requestParameters);
    }

    public void loadPortraitVideoAd(RequestParameters requestParameters, PortraitVideoAdListener portraitVideoAdListener) {
        this.loadPortraitVideoAd(requestParameters, (FeedAdListener)portraitVideoAdListener);
    }

    public void loadPortraitVideoAd(RequestParameters requestParameters, FeedAdListener feedAdListener) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), "pvideo", this.isCacheVideo, this.mTimeoutMillis);
        f f2 = new f(this.mContext, new ac(feedAdListener), dd2);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.b(requestParameters);
    }

    public void loadFeedEntryAd(RequestParameters requestParameters, EntryAdListener entryAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), entryAdListener, this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.b(requestParameters);
    }

    public void loadInsiteAd(RequestParameters requestParameters, FeedAdListener feedAdListener) {
        f f2 = new f(this.mContext, new ac(feedAdListener), new dd(this.mContext, this.getAdPlacemenId(requestParameters), "insite", this.isCacheVideo, this.mTimeoutMillis));
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.b(requestParameters);
    }

    public void loadPrerollVideo(RequestParameters requestParameters, FeedAdListener feedAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), new ac(feedAdListener), this.isCacheVideo, 8000, "preroll");
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.b(requestParameters);
    }

    public void loadExpressAd(RequestParameters requestParameters, ExpressAdListener expressAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), expressAdListener, this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.b(requestParameters);
    }

    public String getFeedBiddingToken(RequestParameters requestParameters) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), "feed", this.isCacheVideo, this.mTimeoutMillis);
        RequestParameters requestParameters2 = requestParameters;
        if (requestParameters2 == null) {
            requestParameters2 = new RequestParameters.Builder().build();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            dd2.h(this.mAppSid);
        }
        dd2.r = this.getBidFloor(requestParameters);
        dd2.a(requestParameters2);
        this.mRequestParameters = requestParameters2;
        return dd2.l();
    }

    public String getExpressFeedBiddingToken(RequestParameters requestParameters) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), "feed", this.isCacheVideo, this.mTimeoutMillis);
        dd2.a(1);
        RequestParameters requestParameters2 = requestParameters;
        if (requestParameters2 == null) {
            requestParameters2 = new RequestParameters.Builder().build();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            dd2.h(this.mAppSid);
        }
        dd2.r = this.getBidFloor(requestParameters);
        dd2.a(requestParameters2);
        this.mRequestParameters = requestParameters2;
        return dd2.l();
    }

    public void loadBidAdForFeed(String string, FeedAdListener feedAdListener) {
        this.loadBiddingAd(this.mRequestParameters, "feed", string, feedAdListener, null);
    }

    public void loadBidAdForExpress(String string, ExpressAdListener expressAdListener) {
        this.loadBiddingAd(this.mRequestParameters, "feed", string, null, expressAdListener);
    }

    @Deprecated
    public void setFeedBiddingData(RequestParameters requestParameters, String string, FeedAdListener feedAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), new ac(feedAdListener), this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.a(requestParameters);
        f2.a(string);
    }

    @Deprecated
    public void setExpressFeedBiddingData(RequestParameters requestParameters, String string, ExpressAdListener expressAdListener) {
        f f2 = new f(this.mContext, this.getAdPlacemenId(requestParameters), expressAdListener, this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.a(requestParameters);
        f2.a(string);
    }

    public String getPortraitVideoBiddingToken(RequestParameters requestParameters) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), "pvideo", this.isCacheVideo, this.mTimeoutMillis);
        RequestParameters requestParameters2 = requestParameters;
        if (requestParameters2 == null) {
            requestParameters2 = new RequestParameters.Builder().build();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            dd2.h(this.mAppSid);
        }
        dd2.r = this.getBidFloor(requestParameters);
        dd2.a(requestParameters2);
        this.mRequestParameters = requestParameters2;
        return dd2.l();
    }

    @Deprecated
    public void loadBidAdForPortraitVideo(String string, PortraitVideoAdListener portraitVideoAdListener) {
        this.loadBiddingAd(this.mRequestParameters, "pvideo", string, portraitVideoAdListener, null);
    }

    public void loadBidAdForPortraitVideo(String string, FeedAdListener feedAdListener) {
        this.loadBiddingAd(this.mRequestParameters, "pvideo", string, feedAdListener, null);
    }

    @Deprecated
    public void setPortraitVideoBiddingData(RequestParameters requestParameters, String string, PortraitVideoAdListener portraitVideoAdListener) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), "pvideo", this.isCacheVideo, this.mTimeoutMillis);
        f f2 = new f(this.mContext, new ac(portraitVideoAdListener), dd2);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            f2.b(this.mAppSid);
        }
        f2.a(this.getBidFloor(requestParameters));
        f2.a(this.isCacheVideoOnlyWifi);
        f2.a(new aj());
        f2.a(requestParameters);
        f2.a(string);
    }

    private void loadBiddingAd(RequestParameters requestParameters, String string, String string2, FeedAdListener feedAdListener, ExpressAdListener expressAdListener) {
        dd dd2 = new dd(this.mContext, this.getAdPlacemenId(requestParameters), string, this.isCacheVideo, this.mTimeoutMillis);
        if (!TextUtils.isEmpty((CharSequence)this.mAppSid)) {
            dd2.h(this.mAppSid);
        }
        dd2.r = this.getBidFloor(requestParameters);
        dd2.c(this.isCacheVideoOnlyWifi);
        if (feedAdListener != null) {
            dd2.a(new ac(feedAdListener));
        } else if (expressAdListener != null) {
            dd2.a(expressAdListener);
            dd2.a(1);
        }
        dd2.a(new aj());
        if (requestParameters == null) {
            requestParameters = new RequestParameters.Builder().build();
        }
        dd2.a(requestParameters);
        dd2.l();
        dd2.c(string2);
    }

    private String getAdPlacemenId(RequestParameters requestParameters) {
        String string;
        if (requestParameters != null && !TextUtils.isEmpty((CharSequence)(string = requestParameters.getAdPlacementId()))) {
            return string;
        }
        return this.mAdPlacementId;
    }

    private int getBidFloor(RequestParameters requestParameters) {
        int n2;
        if (requestParameters != null && (n2 = requestParameters.getBidFloor()) > 0) {
            return n2;
        }
        return this.mBidFloor;
    }

    public void setAppSid(String string) {
        this.mAppSid = string;
    }

    public void setBidFloor(int n2) {
        this.mBidFloor = n2;
    }

    public static interface ExpressAdListener {
        public void onNativeLoad(List<ExpressResponse> var1);

        public void onNativeFail(int var1, String var2, ExpressResponse var3);

        public void onNoAd(int var1, String var2, ExpressResponse var3);

        public void onVideoDownloadSuccess();

        public void onVideoDownloadFailed();

        public void onLpClosed();
    }

    @Deprecated
    public static interface PortraitVideoAdListener
    extends FeedAdListener {
        public void onAdClick();
    }

    public static interface EntryAdListener {
        public void onNativeLoad(List<EntryResponse> var1);

        public void onNativeFail(int var1, String var2);

        public void onNoAd(int var1, String var2);

        public void onLpClosed();
    }

    public static interface FeedAdListener {
        public void onNativeLoad(List<NativeResponse> var1);

        public void onNativeFail(int var1, String var2, NativeResponse var3);

        public void onNoAd(int var1, String var2, NativeResponse var3);

        public void onVideoDownloadSuccess();

        public void onVideoDownloadFailed();

        public void onLpClosed();
    }
}

