/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.mobads.sdk.api.BDDialogParams;
import com.baidu.mobads.sdk.api.IXAdContainerFactory;
import com.baidu.mobads.sdk.api.MobadsPermissionSettings;
import com.baidu.mobads.sdk.internal.aa;
import com.baidu.mobads.sdk.internal.ay;
import com.baidu.mobads.sdk.internal.cq;
import com.baidu.mobads.sdk.internal.e;
import org.json.JSONException;
import org.json.JSONObject;

public class BDAdConfig {
    private boolean mHttps;
    private int mVideoCacheCapacityMb;
    private String mAppName;
    private Context mAppContext;
    private String mAppsid;
    private String mChannelId;
    private boolean mLpMultiProcess;
    private JSONObject mConfigObj;
    private boolean mUseActivityDialog = true;
    private JSONObject mDialogParams;
    private boolean mMtjSwitch;
    private boolean mCloseShake;
    private boolean mDebug = false;
    private String mWXAPPid;
    private BDAdInitListener mBDAdInitListener;
    private boolean mSplashLog = false;
    private JSONObject mExtraParams;

    private BDAdConfig(Context context, Builder builder) {
        this.mHttps = builder.mHttps;
        this.mAppContext = context;
        this.mVideoCacheCapacityMb = builder.mVideoCacheCapacityMb;
        this.mAppName = builder.mAppName;
        this.mAppsid = builder.mAppsid;
        this.mChannelId = builder.mChannelId;
        this.mLpMultiProcess = builder.mLpSupportMultiProcess;
        this.mUseActivityDialog = builder.mUseActivityDialog;
        this.mDialogParams = builder.mDialogParams;
        this.mMtjSwitch = builder.mMtjSwitch;
        this.mCloseShake = builder.mCloseShake;
        this.mDebug = builder.mDebug;
        this.mWXAPPid = builder.mWXAPPid;
        this.mBDAdInitListener = builder.mBDAdInitListener;
        this.mSplashLog = builder.mSplashLog;
        this.mExtraParams = builder.mExtraParams;
    }

    public void init() {
        this.initConfig();
        if (this.mConfigObj != null) {
            try {
                this.mConfigObj.put("gmss", e.a());
                this.mConfigObj.put("toss", e.b());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        aa.a().a(this.mAppContext, new aa.a(){

            @Override
            public void onSuccess() {
                IXAdContainerFactory iXAdContainerFactory = aa.a().c();
                if (iXAdContainerFactory != null) {
                    iXAdContainerFactory.initConfig(BDAdConfig.this.mConfigObj);
                    iXAdContainerFactory.onTaskDistribute("permission_module", MobadsPermissionSettings.getPermissionInfo());
                }
                if (BDAdConfig.this.mBDAdInitListener != null) {
                    BDAdConfig.this.mBDAdInitListener.success();
                }
            }

            @Override
            public void onFailure() {
                if (BDAdConfig.this.mBDAdInitListener != null) {
                    BDAdConfig.this.mBDAdInitListener.fail();
                }
            }
        });
    }

    public void preInit() {
        try {
            this.initConfig();
            aa.a().a(this.mAppContext, new aa.a(){

                @Override
                public void onSuccess() {
                    IXAdContainerFactory iXAdContainerFactory = aa.a().c();
                    if (BDAdConfig.this.mBDAdInitListener != null) {
                        BDAdConfig.this.mBDAdInitListener.success();
                    }
                }

                @Override
                public void onFailure() {
                    if (BDAdConfig.this.mBDAdInitListener != null) {
                        BDAdConfig.this.mBDAdInitListener.fail();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void initConfig() {
        try {
            if (this.mConfigObj == null) {
                this.mConfigObj = new JSONObject();
            }
            this.mConfigObj.put("https", (Object)("" + this.mHttps));
            this.mConfigObj.put("appName", (Object)this.mAppName);
            this.mConfigObj.put("videoCacheSize", (Object)("" + this.mVideoCacheCapacityMb));
            this.mConfigObj.put("appsid", (Object)this.mAppsid);
            this.mConfigObj.put("channelId", (Object)this.mChannelId);
            this.mConfigObj.put("lpMultiProcess", (Object)("" + this.mLpMultiProcess));
            this.mConfigObj.put("useActivityDialog", (Object)("" + this.mUseActivityDialog));
            this.mConfigObj.put("dialog_params", (Object)this.mDialogParams);
            this.mConfigObj.put("mtj_switch", this.mMtjSwitch);
            this.mConfigObj.put("sp_shake", this.mCloseShake);
            this.mConfigObj.put("sdk_debug", this.mDebug);
            this.mConfigObj.put("splashLog", this.mSplashLog);
            this.mConfigObj.put("extras", (Object)this.mExtraParams);
            if (!TextUtils.isEmpty((CharSequence)this.mWXAPPid)) {
                this.mConfigObj.put("wxAppid", (Object)this.mWXAPPid);
            }
            cq.a().a(this.mLpMultiProcess);
            cq.a().b(this.mHttps);
            ay.a(this.mDebug);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void clearMemoryCache() {
        try {
            IXAdContainerFactory iXAdContainerFactory = aa.a().c();
            iXAdContainerFactory.onTaskDistribute("clear_memory_cache", null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static interface BDAdInitListener {
        public void success();

        public void fail();
    }

    public static class Builder {
        private boolean mHttps = true;
        private int mVideoCacheCapacityMb;
        private String mAppName;
        private String mAppsid;
        private boolean mUseActivityDialog = true;
        private String mChannelId;
        private boolean mLpSupportMultiProcess;
        private JSONObject mDialogParams;
        private boolean mMtjSwitch = true;
        private boolean mCloseShake = false;
        private String mWXAPPid;
        private boolean mDebug = false;
        private BDAdInitListener mBDAdInitListener;
        private boolean mSplashLog = false;
        private JSONObject mExtraParams;

        public Builder setSplashLog(boolean bl2) {
            this.mSplashLog = bl2;
            return this;
        }

        public Builder setDebug(boolean bl2) {
            this.mDebug = bl2;
            return this;
        }

        public Builder setMtjSwitch(boolean bl2) {
            this.mMtjSwitch = bl2;
            return this;
        }

        public Builder setCloseShake(boolean bl2) {
            this.mCloseShake = bl2;
            return this;
        }

        public Builder setAppName(String string) {
            this.mAppName = string;
            return this;
        }

        public Builder setHttps(boolean bl2) {
            this.mHttps = bl2;
            return this;
        }

        public Builder setVideoCacheCapacityMb(int n2) {
            this.mVideoCacheCapacityMb = n2;
            return this;
        }

        public Builder setWXAppid(String string) {
            this.mWXAPPid = string;
            return this;
        }

        public Builder setAppsid(String string) {
            this.mAppsid = string;
            return this;
        }

        @Deprecated
        public Builder useActivityDialog(Boolean bl2) {
            this.mUseActivityDialog = bl2;
            return this;
        }

        public Builder setDialogParams(BDDialogParams bDDialogParams) {
            this.mDialogParams = bDDialogParams.toJson();
            return this;
        }

        public Builder setLpMultiProcess(boolean bl2) {
            this.mLpSupportMultiProcess = bl2;
            return this;
        }

        public Builder setChannelId(String string) {
            this.mChannelId = string;
            return this;
        }

        public Builder setBDAdInitListener(BDAdInitListener bDAdInitListener) {
            this.mBDAdInitListener = bDAdInitListener;
            return this;
        }

        public Builder putExtraParam(String string, String string2) {
            if (this.mExtraParams == null) {
                this.mExtraParams = new JSONObject();
            }
            try {
                this.mExtraParams.put(string, (Object)string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return this;
        }

        public BDAdConfig build(Context context) {
            return new BDAdConfig(context, this);
        }
    }
}

