/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import java.util.HashMap;
import java.util.Map;

public final class RequestParameters {
    public static final String TAG = "RequestParameters";
    public static final int MAX_ASSETS_RESERVED = 15;
    public static final int ADS_TYPE_OPENPAGE = 1;
    public static final int ADS_TYPE_DOWNLOAD = 2;
    public static final int DOWNLOAD_APP_CONFIRM_ONLY_MOBILE = 1;
    public static final int DOWNLOAD_APP_CONFIRM_ALWAYS = 2;
    public static final int DOWNLOAD_APP_CONFIRM_NEVER = 3;
    public static final int DOWNLOAD_APP_CONFIRM_CUSTOM_BY_APP = 4;
    private final String mKeywords;
    private int adsType;
    private boolean confirmDownloading;
    private Map<String, String> extras;
    private Map<String, String> customExt;
    private int width = 0;
    private int height = 0;
    private int downloadAppConfirmPolicy;
    private boolean customSize;
    private String mAdPlaceId;
    private int mBidFloor = -1;

    private RequestParameters(Builder builder) {
        this.mKeywords = builder.keywords;
        this.adsType = builder.adsType;
        this.width = builder.width;
        this.height = builder.height;
        this.customSize = builder.customSize;
        this.confirmDownloading = builder.clickConfirm;
        this.downloadAppConfirmPolicy = builder.downloadAppConfirmPolicy;
        this.mAdPlaceId = builder.adPlaceId;
        this.mBidFloor = builder.bidFloor;
        this.setExtras(builder.extras);
        this.setExt(builder.customExt);
    }

    public final String getKeywords() {
        return this.mKeywords;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isCustomSize() {
        return this.customSize;
    }

    public int getAdsType() {
        return this.adsType;
    }

    public void setAdsType(int n2) {
        this.adsType = n2;
    }

    public boolean isConfirmDownloading() {
        return this.confirmDownloading;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public Map<String, String> getExt() {
        return this.customExt;
    }

    public void setExtras(Map<String, String> map) {
        this.extras = map;
    }

    public void setExt(Map<String, String> map) {
        this.customExt = map;
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("mKeywords", this.mKeywords);
        hashMap.put("adsType", this.adsType);
        hashMap.put("confirmDownloading", this.confirmDownloading);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (this.extras != null) {
            for (Map.Entry<String, String> object : this.extras.entrySet()) {
                hashMap2.put(object.getKey(), object.getValue());
            }
        }
        hashMap.put("extras", hashMap2);
        HashMap hashMap3 = new HashMap();
        if (this.customExt != null) {
            for (Map.Entry<String, String> entry : this.customExt.entrySet()) {
                hashMap3.put(entry.getKey(), entry.getValue());
            }
        }
        hashMap.put("ext", hashMap3);
        return hashMap;
    }

    public String getAdPlacementId() {
        return this.mAdPlaceId;
    }

    public int getBidFloor() {
        return this.mBidFloor;
    }

    public int getAPPConfirmPolicy() {
        return this.downloadAppConfirmPolicy;
    }

    public static class Builder {
        private String keywords;
        private Map<String, String> extras = new HashMap<String, String>();
        private Map<String, String> customExt = new HashMap<String, String>();
        private int adsType = 3;
        private boolean clickConfirm = false;
        private int width = 640;
        private int height = 480;
        private int downloadAppConfirmPolicy = 3;
        private boolean customSize = false;
        private String adPlaceId;
        private int bidFloor = -1;

        public final Builder setWidth(int n2) {
            this.width = n2;
            this.customSize = true;
            return this;
        }

        public final Builder setHeight(int n2) {
            this.height = n2;
            this.customSize = true;
            return this;
        }

        @Deprecated
        public final Builder confirmDownloading(boolean bl2) {
            if (bl2) {
                this.downloadAppConfirmPolicy(2);
            } else {
                this.downloadAppConfirmPolicy(3);
            }
            return this;
        }

        @Deprecated
        public final Builder downloadAppConfirmPolicy(int n2) {
            this.downloadAppConfirmPolicy = n2;
            return this;
        }

        public final Builder setAdPlaceId(String string) {
            this.adPlaceId = string;
            return this;
        }

        public final Builder setBidFloor(int n2) {
            this.bidFloor = n2;
            return this;
        }

        public final Builder addExtra(String string, String string2) {
            this.extras.put(string, string2);
            return this;
        }

        public final Builder addCustExt(String string, String string2) {
            this.customExt.put(string, string2);
            return this;
        }

        public final RequestParameters build() {
            return new RequestParameters(this);
        }
    }
}

