/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.baidu.mobads.sdk.api.FeedPortraitVideoView;
import com.baidu.mobads.sdk.api.IFeedPortraitListener;
import com.baidu.mobads.sdk.api.INativeVideoListener;
import com.baidu.mobads.sdk.api.NativeResponse;
import com.baidu.mobads.sdk.api.XAdNativeResponse;
import com.baidu.mobads.sdk.api.XNativeViewManager;
import com.baidu.mobads.sdk.internal.bt;
import com.baidu.mobads.sdk.internal.cp;

public class XNativeView
extends RelativeLayout
implements View.OnClickListener {
    private static final String TAG = "XNativeView";
    private XAdNativeResponse mCurrentNativeItem;
    private FeedPortraitVideoView mVideoView;
    private INativeVideoListener mFeedVideoListener;
    private boolean videoMute = true;
    private int mProgressColor = -1;
    private int mProgressBg = -16777216;
    private boolean mShowProgressBar = false;
    private int mProgressHeight = 1;
    private bt mAdLogger = bt.a();
    private INativeViewClickListener mNativeViewListener;

    public XNativeView(Context context) {
        this(context, null);
    }

    public XNativeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public XNativeView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setBackgroundColor(Color.parseColor((String)"#000000"));
    }

    public void setNativeItem(NativeResponse nativeResponse) {
        this.mCurrentNativeItem = (XAdNativeResponse)nativeResponse;
        this.renderView();
    }

    public void setNativeViewClickListener(INativeViewClickListener iNativeViewClickListener) {
        this.mNativeViewListener = iNativeViewClickListener;
    }

    public void setNativeVideoListener(INativeVideoListener iNativeVideoListener) {
        this.mFeedVideoListener = iNativeVideoListener;
    }

    public void onClick(View view) {
    }

    public void setVideoMute(boolean bl2) {
        this.videoMute = bl2;
        if (this.mVideoView != null) {
            this.mVideoView.setVideoMute(this.videoMute);
        }
    }

    private void renderView() {
        if (this.mCurrentNativeItem == null) {
            return;
        }
        NativeResponse.MaterialType materialType = this.mCurrentNativeItem.getMaterialType();
        if (this.mVideoView == null) {
            this.mVideoView = new FeedPortraitVideoView(this.getContext());
            this.mVideoView.setShowProgress(this.mShowProgressBar);
            this.mVideoView.setProgressBarColor(this.mProgressColor);
            this.mVideoView.setProgressBackgroundColor(this.mProgressBg);
            this.mVideoView.setProgressHeightInDp(this.mProgressHeight);
            this.addView((View)this.mVideoView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.mVideoView.setFeedPortraitListener(new IFeedPortraitListener(){

                @Override
                public void playCompletion() {
                    if (XNativeView.this.mFeedVideoListener != null) {
                        XNativeView.this.mFeedVideoListener.onCompletion();
                    }
                }

                @Override
                public void playError() {
                    if (XNativeView.this.mFeedVideoListener != null) {
                        XNativeView.this.mFeedVideoListener.onError();
                    }
                }

                @Override
                public void pauseBtnClick() {
                    XNativeView.this.callNativeViewClick();
                }

                @Override
                public void playRenderingStart() {
                    if (XNativeView.this.mVideoView != null) {
                        XNativeView.this.mVideoView.hideFeedCoverPic(XNativeView.this.mCurrentNativeItem);
                    }
                    XNativeViewManager.getInstance().resetAllPlayer(XNativeView.this);
                    if (XNativeView.this.mFeedVideoListener != null) {
                        XNativeView.this.mFeedVideoListener.onRenderingStart();
                    }
                }

                @Override
                public void playPause() {
                    if (XNativeView.this.mFeedVideoListener != null) {
                        XNativeView.this.mFeedVideoListener.onPause();
                    }
                }

                @Override
                public void playResume() {
                    if (XNativeView.this.mFeedVideoListener != null) {
                        XNativeView.this.mFeedVideoListener.onResume();
                    }
                }
            });
        }
        if (materialType == NativeResponse.MaterialType.NORMAL) {
            this.mVideoView.showNormalPic(this.mCurrentNativeItem);
        } else if (materialType == NativeResponse.MaterialType.VIDEO) {
            this.showView(this.mCurrentNativeItem);
        }
    }

    public void pause() {
        if (this.mVideoView != null) {
            this.mVideoView.pause();
        }
    }

    public void resume() {
        if (this.mVideoView != null) {
            this.mVideoView.resume();
        }
    }

    public void render() {
        if (this.shouldAutoPlay()) {
            this.play();
        } else {
            this.initAdVideoView();
        }
    }

    public void stop() {
        if (this.mVideoView != null) {
            this.mVideoView.stop();
        }
    }

    private void play() {
        if (this.mVideoView != null) {
            this.initAdVideoView();
            this.mVideoView.hideFeedPauseBtn(this.mCurrentNativeItem);
            this.mVideoView.play();
        }
    }

    private boolean shouldAutoPlay() {
        boolean bl2 = this.mCurrentNativeItem != null && this.mCurrentNativeItem.isAutoPlay();
        boolean bl3 = this.mCurrentNativeItem == null || this.mCurrentNativeItem.isNonWifiAutoPlay();
        Boolean bl4 = cp.a().a(this.getContext().getApplicationContext());
        return bl2 && bl4 != false || bl3 && bl4 == false;
    }

    public void setShowProgress(boolean bl2) {
        this.mShowProgressBar = bl2;
        if (this.mVideoView != null) {
            this.mVideoView.setShowProgress(bl2);
        }
    }

    public void setProgressBackgroundColor(int n2) {
        this.mProgressBg = n2;
        if (this.mVideoView != null) {
            this.mVideoView.setProgressBackgroundColor(n2);
        }
    }

    public void setProgressBarColor(int n2) {
        this.mProgressColor = n2;
        if (this.mVideoView != null) {
            this.mVideoView.setProgressBarColor(n2);
        }
    }

    public void setProgressHeightInDp(int n2) {
        this.mProgressHeight = n2;
        if (this.mVideoView != null) {
            this.mVideoView.setProgressHeightInDp(n2);
        }
    }

    private void showView(XAdNativeResponse xAdNativeResponse) {
        if (this.mVideoView == null) {
            return;
        }
        this.mVideoView.showFeedVideoCover(xAdNativeResponse);
    }

    public void handleCover() {
        if (this.mVideoView == null) {
            return;
        }
        this.mVideoView.handleFeedCover(this.mCurrentNativeItem);
    }

    private void initAdVideoView() {
        if (this.mVideoView == null) {
            return;
        }
        this.mVideoView.setCanClickVideo(true);
        this.mVideoView.setAdData(this.mCurrentNativeItem);
        this.mVideoView.systemSetVideoMute(this.videoMute);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        XNativeViewManager.getInstance().removeNativeView(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        XNativeViewManager.getInstance().addItem(this);
    }

    private void callNativeViewClick() {
        if (this.mNativeViewListener != null) {
            this.mNativeViewListener.onNativeViewClick(this);
        }
    }

    private boolean isVisible(View view, int n2) {
        if (view == null || view.getVisibility() != 0 || view.getParent() == null) {
            return false;
        }
        Rect rect = new Rect();
        if (!view.getGlobalVisibleRect(rect)) {
            return false;
        }
        long l2 = (long)rect.height() * (long)rect.width();
        long l3 = (long)view.getHeight() * (long)view.getWidth();
        if (l3 <= 0L) {
            return false;
        }
        return 100L * l2 >= (long)n2 * l3;
    }

    public void setUseDownloadFrame(boolean bl2) {
        if (this.mVideoView != null) {
            this.mVideoView.setUseDownloadFrame(bl2);
        }
    }

    public static interface INativeViewClickListener {
        public void onNativeViewClick(XNativeView var1);
    }
}

