/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import android.text.TextUtils;
import com.baidu.mobads.sdk.api.CpuLpFontSize;
import java.util.HashMap;
import java.util.Map;

public class CPUWebAdRequestParam {
    private final Map<String, Object> mParameters = new HashMap<String, Object>();
    private static final String DARK_MODE = "dark";
    private static final String LIGHT_MODE = "light";

    private CPUWebAdRequestParam(Builder builder) {
        if (builder != null && builder.mExtras != null) {
            this.mParameters.putAll(builder.mExtras);
        }
    }

    public Map<String, Object> getParameters() {
        return this.mParameters;
    }

    public static class Builder {
        private HashMap<String, Object> mExtras = new HashMap();

        public Builder setCustomUserId(String string) {
            this.mExtras.put("outerId", string);
            return this;
        }

        public Builder setSubChannelId(String string) {
            this.mExtras.put("scid", string);
            return this;
        }

        public Builder setLpDarkMode(boolean bl2) {
            this.mExtras.put("preferscolortheme", bl2 ? CPUWebAdRequestParam.DARK_MODE : CPUWebAdRequestParam.LIGHT_MODE);
            return this;
        }

        public Builder setLpFontSize(CpuLpFontSize cpuLpFontSize) {
            this.mExtras.put("prefersfontsize", cpuLpFontSize.getValue());
            return this;
        }

        public Builder setCityIfLocalChannel(String string) {
            this.mExtras.put("city", string);
            return this;
        }

        public Builder addExtra(String string, String string2) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                this.mExtras.put(string, string2);
            }
            return this;
        }

        public CPUWebAdRequestParam build() {
            return new CPUWebAdRequestParam(this);
        }
    }
}

