/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.baidu.mobads.sdk.api.BaiduNativeManager;
import com.baidu.mobads.sdk.api.IPatchAdListener;
import com.baidu.mobads.sdk.api.NativeResponse;
import com.baidu.mobads.sdk.api.PatchAdView;
import com.baidu.mobads.sdk.api.PrerollVideoResponse;
import com.baidu.mobads.sdk.api.RequestParameters;
import com.baidu.mobads.sdk.api.XAdVideoResponse;
import java.util.ArrayList;
import java.util.List;

public class PatchVideoNative {
    private Context mContext;
    private String mAdPlaceId;
    private RelativeLayout mParentView;
    private IPatchVideoNativeListener mListener;
    private BaiduNativeManager mBaiduNativeManager;
    private PatchAdView mPatchView;
    private PrerollVideoResponse mAdResponse;
    private boolean mIsMute;
    private String mAppSid;

    public PatchVideoNative(Context context, String string, RelativeLayout relativeLayout, IPatchVideoNativeListener iPatchVideoNativeListener) {
        this.mContext = context;
        this.mAdPlaceId = string;
        this.mParentView = relativeLayout;
        this.mListener = iPatchVideoNativeListener;
        this.mBaiduNativeManager = new BaiduNativeManager(this.mContext, this.mAdPlaceId);
    }

    public void requestAd(RequestParameters requestParameters) {
        if (this.mBaiduNativeManager != null) {
            this.mBaiduNativeManager.setAppSid(this.mAppSid);
            this.mBaiduNativeManager.loadPrerollVideo(requestParameters, new BaiduNativeManager.FeedAdListener(){

                @Override
                public void onNativeLoad(List<NativeResponse> list) {
                    ArrayList<XAdVideoResponse> arrayList = new ArrayList<XAdVideoResponse>();
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        XAdVideoResponse xAdVideoResponse = new XAdVideoResponse(list.get(i2));
                        arrayList.add(xAdVideoResponse);
                    }
                    PatchVideoNative.this.mAdResponse = (PrerollVideoResponse)arrayList.get(0);
                    PatchVideoNative.this.callLoadSucc();
                }

                @Override
                public void onNativeFail(int n2, String string, NativeResponse nativeResponse) {
                    PatchVideoNative.this.callLoadFail(n2, string);
                }

                @Override
                public void onNoAd(int n2, String string, NativeResponse nativeResponse) {
                    PatchVideoNative.this.callLoadFail(n2, string);
                }

                @Override
                public void onVideoDownloadSuccess() {
                }

                @Override
                public void onVideoDownloadFailed() {
                }

                @Override
                public void onLpClosed() {
                }
            });
        }
    }

    public void setVideoMute(boolean bl2) {
        this.mIsMute = bl2;
        if (this.mPatchView != null) {
            this.mPatchView.setVideoVolume(this.mIsMute);
        }
    }

    public long getCurrentPosition() {
        if (this.mPatchView != null) {
            return this.mPatchView.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration() {
        if (this.mPatchView != null) {
            return this.mPatchView.getDuration();
        }
        return 0L;
    }

    private void callLoadSucc() {
        if (this.mListener != null) {
            this.mListener.onAdLoad(this.mAdResponse.getMaterialType());
        }
        this.mPatchView = new PatchAdView(this.mContext);
        this.mPatchView.setVideoVolume(this.mIsMute);
        this.mParentView.addView((View)this.mPatchView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mPatchView.setPatchAdListener(new IPatchAdListener(){

            @Override
            public void playCompletion() {
                PatchVideoNative.this.callPlayCompletion();
            }

            @Override
            public void playError() {
                PatchVideoNative.this.callPlayError();
            }

            @Override
            public void onAdShow() {
                PatchVideoNative.this.callAdShow();
            }

            @Override
            public void onAdClicked() {
                PatchVideoNative.this.callAdClick();
            }
        });
        this.mPatchView.setAdData((XAdVideoResponse)this.mAdResponse);
    }

    private void callLoadFail(int n2, String string) {
        if (this.mListener != null) {
            this.mListener.onAdFailed(n2, string);
        }
    }

    private void callPlayCompletion() {
        if (this.mListener != null) {
            this.mListener.playCompletion();
        }
    }

    private void callPlayError() {
        if (this.mListener != null) {
            this.mListener.playError();
        }
    }

    private void callAdShow() {
        if (this.mListener != null) {
            this.mListener.onAdShow();
        }
    }

    private void callAdClick() {
        if (this.mListener != null) {
            this.mListener.onAdClick();
        }
    }

    public void setAppSid(String string) {
        this.mAppSid = string;
    }

    public static interface IPatchVideoNativeListener {
        public void onAdLoad(String var1);

        public void onAdFailed(int var1, String var2);

        public void playCompletion();

        public void playError();

        public void onAdShow();

        public void onAdClick();
    }
}

