/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobads.sdk.api;

import com.baidu.mobads.sdk.internal.bu;
import org.json.JSONException;
import org.json.JSONObject;

public class SplashFocusParams {
    private final Builder mBuilder;

    public SplashFocusParams(Builder builder) {
        this.mBuilder = builder;
    }

    public JSONObject getFocusParams() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("right_margin", this.mBuilder.iconRightMarginDp);
            jSONObject.put("bottom_margin", this.mBuilder.iconBottomMarginDp);
            jSONObject.put("icon_size", this.mBuilder.iconSizeDp);
            if (!this.mBuilder.autoAnimOffset) {
                jSONObject.put("anim_offset_y", this.mBuilder.animOffsetPx);
            }
            jSONObject.put("icon_dark_alpha", this.mBuilder.darkAlpha);
        }
        catch (JSONException jSONException) {
            bu.a().a(jSONException);
        }
        return jSONObject;
    }

    public static class Builder {
        private int iconRightMarginDp = 15;
        private int iconBottomMarginDp = 95;
        private int iconSizeDp = 44;
        private boolean autoAnimOffset = true;
        private int animOffsetPx = 0;
        private double darkAlpha = 0.0;

        public Builder setIconRightMarginDp(int n2) {
            this.iconRightMarginDp = n2;
            return this;
        }

        public Builder setIconBottomMarginDp(int n2) {
            this.iconBottomMarginDp = n2;
            return this;
        }

        public Builder setIconSizeDp(int n2) {
            this.iconSizeDp = n2;
            return this;
        }

        public Builder setDarkAlpha(double d2) {
            this.darkAlpha = d2;
            return this;
        }

        @Deprecated
        public Builder setAnimOffsetPx(int n2) {
            this.autoAnimOffset = false;
            this.animOffsetPx = n2;
            return this;
        }

        public SplashFocusParams build() {
            return new SplashFocusParams(this);
        }
    }
}

